/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.dropwizard;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.metrics.utils.MetricInfo;
import org.apache.iotdb.metrics.utils.MetricType;

public class DropwizardMetricNameTool {
    private static final String TAG_SEPARATOR = ".";

    private DropwizardMetricNameTool() {
    }

    public static MetricInfo transformFromString(MetricType metricType, String flatString) {
        MetricInfo metricInfo;
        int firstIndex = flatString.indexOf("{");
        int lastIndex = flatString.indexOf("}");
        if (firstIndex == -1 || lastIndex == -1) {
            String name = flatString.replaceAll("[^a-zA-Z0-9:_\\]\\[]", "_");
            metricInfo = new MetricInfo(metricType, name, new String[0]);
        } else {
            String name = flatString.substring(0, firstIndex).replaceAll("[^a-zA-Z0-9:_\\]\\[]", "_");
            String tagsPart = flatString.substring(firstIndex + 1, lastIndex);
            metricInfo = 0 == tagsPart.length() ? new MetricInfo(metricType, name, new String[0]) : new MetricInfo(metricType, name, tagsPart.split("\\."));
        }
        return metricInfo;
    }

    public static String toFlatString(MetricInfo metricInfo) {
        String name = metricInfo.getName();
        Map<String, String> tags = metricInfo.getTags();
        return name.replace("{", "").replace("}", "") + "{" + tags.entrySet().stream().map(t2 -> ((String)t2.getKey()).replace(TAG_SEPARATOR, "") + TAG_SEPARATOR + ((String)t2.getValue()).replace(TAG_SEPARATOR, "")).collect(Collectors.joining(TAG_SEPARATOR)).replace("{", "").replace("}", "") + "}";
    }
}

