/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.udf.builtin;

import java.io.IOException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.udf.utils.UDFDataTypeTransformer;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.exception.UDFInputSeriesDataTypeNotValidException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFInRange
implements UDTF {
    protected TSDataType dataType;
    protected double upper;
    protected double lower;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFException {
        validator.validateInputSeriesNumber(1).validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE).validateRequiredAttribute("upper").validateRequiredAttribute("lower").validate(args -> (Double)args[0] >= (Double)args[1], "Upper can not be smaller than lower.", validator.getParameters().getDouble("upper"), validator.getParameters().getDouble("lower"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws MetadataException {
        this.upper = parameters.getDouble("upper");
        this.lower = parameters.getDouble("lower");
        this.dataType = UDFDataTypeTransformer.transformToTsDataType(parameters.getDataType(0));
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.BOOLEAN);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws UDFInputSeriesDataTypeNotValidException, IOException {
        long time = row.getTime();
        switch (this.dataType) {
            case INT32: {
                collector.putBoolean(time, (double)row.getInt(0) >= this.lower && this.upper >= (double)row.getInt(0));
                break;
            }
            case INT64: {
                collector.putBoolean(time, (double)row.getLong(0) >= this.lower && this.upper >= (double)row.getLong(0));
                break;
            }
            case FLOAT: {
                collector.putBoolean(time, (double)row.getFloat(0) >= this.lower && this.upper >= (double)row.getFloat(0));
                break;
            }
            case DOUBLE: {
                collector.putBoolean(time, row.getDouble(0) >= this.lower && this.upper >= row.getDouble(0));
                break;
            }
            default: {
                throw new UDFInputSeriesDataTypeNotValidException(0, UDFDataTypeTransformer.transformToUDFDataType(this.dataType), Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
            }
        }
    }
}

