/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterManager {
    private static final Logger logger = LoggerFactory.getLogger(RegisterManager.class);
    private final List<IService> iServices = new ArrayList<IService>();
    private static long deregisterTimeOut = 10000L;

    public void register(IService service) throws StartupException {
        for (IService s2 : this.iServices) {
            if (s2.getID() != service.getID()) continue;
            logger.debug("{} has already been registered. skip", (Object)service.getID().getName());
            return;
        }
        this.iServices.add(service);
        service.start();
    }

    public void deregisterAll() {
        Collections.reverse(this.iServices);
        for (IService service : this.iServices) {
            try {
                service.waitAndStop(deregisterTimeOut);
                logger.debug("{} deregistered", (Object)service.getID());
            }
            catch (Exception e) {
                logger.error("Failed to stop {} because:", (Object)service.getID().getName(), (Object)e);
            }
        }
        this.iServices.clear();
        logger.info("deregister all service.");
    }

    public void shutdownAll() throws ShutdownException {
        Collections.reverse(this.iServices);
        for (IService service : this.iServices) {
            service.shutdown(deregisterTimeOut);
        }
        this.iServices.clear();
        logger.info("deregister all service.");
    }

    public static void setDeregisterTimeOut(long deregisterTimeOut) {
        RegisterManager.deregisterTimeOut = deregisterTimeOut;
    }
}

