/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TrainingState;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ModelTable {
    private final Map<String, ModelInformation> modelInfoMap = new ConcurrentHashMap<String, ModelInformation>();

    public boolean containsModel(String modelId) {
        return this.modelInfoMap.containsKey(modelId);
    }

    public void addModel(ModelInformation modelInformation) {
        this.modelInfoMap.put(modelInformation.getModelId(), modelInformation);
    }

    public void removeModel(String modelId) {
        this.modelInfoMap.remove(modelId);
    }

    public List<ModelInformation> getAllModelInformation() {
        return new ArrayList<ModelInformation>(this.modelInfoMap.values());
    }

    public ModelInformation getModelInformationById(String modelId) {
        if (this.modelInfoMap.containsKey(modelId)) {
            return this.modelInfoMap.get(modelId);
        }
        return null;
    }

    public void updateModel(String modelId, String trailId, Map<String, String> modelInfo) {
        this.modelInfoMap.get(modelId).update(trailId, modelInfo);
    }

    public void updateState(String modelId, TrainingState state, String bestTrailId) {
        this.modelInfoMap.get(modelId).updateState(state, bestTrailId);
    }

    public void clear() {
        this.modelInfoMap.clear();
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.modelInfoMap.size(), (OutputStream)stream);
        for (ModelInformation entry : this.modelInfoMap.values()) {
            entry.serialize(stream);
        }
    }

    public static ModelTable deserialize(InputStream stream) throws IOException {
        ModelTable modelTable = new ModelTable();
        int size = ReadWriteIOUtils.readInt(stream);
        for (int i = 0; i < size; ++i) {
            modelTable.addModel(ModelInformation.deserialize(stream));
        }
        return modelTable;
    }
}

