/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent.threadpool;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.ThreadPoolMetrics;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutorMBean;
import org.apache.iotdb.commons.service.JMXService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedThreadPoolExecutor
extends ThreadPoolExecutor
implements WrappedThreadPoolExecutorMBean {
    private static final Logger logger = LoggerFactory.getLogger(WrappedThreadPoolExecutor.class);
    private final String mbeanName;

    public WrappedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, String mbeanName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
        ThreadPoolMetrics.getInstance().registerThreadPool(this, this.mbeanName);
    }

    public WrappedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, IoTThreadFactory ioTThreadFactory, String mbeanName) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ioTThreadFactory);
        this.mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.threadpool", "type", mbeanName);
        JMXService.registerMBean(this, this.mbeanName);
        ThreadPoolMetrics.getInstance().registerThreadPool(this, this.mbeanName);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        JMXService.deregisterMBean(this.mbeanName);
    }

    @Override
    public List<Runnable> shutdownNow() {
        JMXService.deregisterMBean(this.mbeanName);
        return super.shutdownNow();
    }

    @Override
    public int getQueueLength() {
        return this.getQueue().size();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t2) {
        super.afterExecute(r, t2);
        if (t2 == null && r instanceof Future) {
            try {
                Future future = (Future)((Object)r);
                if (future.isDone()) {
                    future.get();
                }
            }
            catch (CancellationException ce) {
                t2 = ce;
            }
            catch (ExecutionException ee) {
                t2 = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t2 != null) {
            logger.error("Exception in thread pool {}", (Object)this.mbeanName, (Object)t2);
        }
    }
}

