/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.auth.entity;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathPrivilege {
    private static final Logger logger = LoggerFactory.getLogger(PathPrivilege.class);
    private Set<Integer> privileges;
    private PartialPath path;
    private AtomicInteger referenceCnt = new AtomicInteger(0);
    public static final Comparator<PathPrivilege> REFERENCE_DESCENT_SORTER = (o1, o2) -> -Integer.compare(o1.referenceCnt.get(), o2.referenceCnt.get());

    public PathPrivilege() {
    }

    public PathPrivilege(PartialPath path) {
        this.path = path;
        this.privileges = new HashSet<Integer>();
    }

    public Set<Integer> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Set<Integer> privileges) {
        this.privileges = privileges;
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public AtomicInteger getReferenceCnt() {
        return this.referenceCnt;
    }

    public void setReferenceCnt(AtomicInteger referenceCnt) {
        this.referenceCnt = referenceCnt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathPrivilege that = (PathPrivilege)o;
        return Objects.equals(this.privileges, that.privileges) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.privileges, this.path);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.path.getFullPath());
        builder.append(" :");
        for (Integer privilegeId : this.privileges) {
            builder.append(" ").append((Object)PrivilegeType.values()[privilegeId]);
        }
        return builder.toString();
    }

    public ByteBuffer serialize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        SerializeUtils.serializeIntSet(this.privileges, dataOutputStream);
        try {
            this.path.serialize(dataOutputStream);
        }
        catch (IOException exception) {
            logger.error("Unexpected exception when serialize path", exception);
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    public void deserialize(ByteBuffer buffer) {
        this.privileges = new HashSet<Integer>();
        SerializeUtils.deserializeIntSet(this.privileges, buffer);
        this.path = (PartialPath)PathDeserializeUtil.deserialize(buffer);
    }
}

