/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;

public class JacksonSerializer<T>
implements Serializer<T> {
    static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private final ObjectMapper objectMapper;

    public JacksonSerializer() {
        this(DEFAULT_OBJECT_MAPPER);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] serialize(T t2) throws SerializationException {
        Assert.notNull(t2, "Object to serialize cannot be null.");
        try {
            return this.writeValueAsBytes(t2);
        }
        catch (JsonProcessingException e) {
            String msg = "Unable to serialize object: " + e.getMessage();
            throw new SerializationException(msg, e);
        }
    }

    protected byte[] writeValueAsBytes(T t2) throws JsonProcessingException {
        return this.objectMapper.writeValueAsBytes(t2);
    }
}

