/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.io.JacksonSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;

public class JacksonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> returnType) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        Assert.notNull(returnType, "Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = returnType;
    }

    @Override
    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return this.objectMapper.readValue(bytes, this.returnType);
    }
}

