/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.iot.client;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.consensus.iot.logdispatcher.Batch;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcher;
import org.apache.iotdb.consensus.iot.logdispatcher.LogDispatcherThreadMetrics;
import org.apache.iotdb.consensus.iot.thrift.TSyncLogEntriesRes;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchLogHandler
implements AsyncMethodCallback<TSyncLogEntriesRes> {
    private final Logger logger = LoggerFactory.getLogger(DispatchLogHandler.class);
    private final LogDispatcher.LogDispatcherThread thread;
    private final Batch batch;
    private final long createTime;
    private final LogDispatcherThreadMetrics logDispatcherThreadMetrics;
    private int retryCount;

    public DispatchLogHandler(LogDispatcher.LogDispatcherThread thread, LogDispatcherThreadMetrics logDispatcherThreadMetrics, Batch batch) {
        this.thread = thread;
        this.logDispatcherThreadMetrics = logDispatcherThreadMetrics;
        this.batch = batch;
        this.createTime = System.nanoTime();
    }

    public void onComplete(TSyncLogEntriesRes response) {
        if (response.getStatuses().size() == 1 && this.needRetry(((TSStatus)response.getStatuses().get(0)).getCode())) {
            this.logger.warn("Can not send {} to peer {} for {} times because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, ((TSStatus)response.getStatuses().get(0)).getMessage()});
            this.sleepCorrespondingTimeAndRetryAsynchronous();
        } else {
            this.thread.getSyncStatus().removeBatch(this.batch);
            this.thread.updateSafelyDeletedSearchIndex();
        }
        this.logDispatcherThreadMetrics.recordSyncLogTimePerRequest(System.nanoTime() - this.createTime);
    }

    private boolean needRetry(int statusCode) {
        return statusCode == TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode() || statusCode == TSStatusCode.SYSTEM_READ_ONLY.getStatusCode() || statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }

    public void onError(Exception exception) {
        this.logger.warn("Can not send {} to peer for {} times {} because {}", new Object[]{this.batch, this.thread.getPeer(), ++this.retryCount, exception});
        this.sleepCorrespondingTimeAndRetryAsynchronous();
    }

    private void sleepCorrespondingTimeAndRetryAsynchronous() {
        long sleepTime = Math.min((long)((double)this.thread.getConfig().getReplication().getBasicRetryWaitTimeMs() * Math.pow(2.0, this.retryCount)), this.thread.getConfig().getReplication().getMaxRetryWaitTimeMs());
        this.thread.getImpl().getRetryService().schedule(() -> {
            if (this.thread.isStopped()) {
                this.logger.debug("LogDispatcherThread {} has been stopped, we will not retrying this Batch {} after {} times", new Object[]{this.thread.getPeer(), this.batch, this.retryCount});
            } else {
                this.thread.sendBatchAsync(this.batch, this);
            }
        }, sleepTime, TimeUnit.MILLISECONDS);
    }
}

