/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;

public class AlterTimeSeriesStatement
extends Statement {
    private PartialPath path;
    private AlterType alterType;
    private Map<String, String> alterMap;
    private String alias;
    private Map<String, String> tagsMap;
    private Map<String, String> attributesMap;
    private final boolean isAlterView;

    public AlterTimeSeriesStatement() {
        this.isAlterView = false;
        this.statementType = StatementType.ALTER_TIMESERIES;
    }

    public AlterTimeSeriesStatement(boolean isAlterView) {
        this.isAlterView = isAlterView;
        this.statementType = isAlterView ? StatementType.ALTER_LOGICAL_VIEW : StatementType.ALTER_TIMESERIES;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.path);
    }

    public PartialPath getPath() {
        return this.path;
    }

    public void setPath(PartialPath path) {
        this.path = path;
    }

    public AlterType getAlterType() {
        return this.alterType;
    }

    public void setAlterType(AlterType alterType) {
        this.alterType = alterType;
    }

    public Map<String, String> getAlterMap() {
        return this.alterMap;
    }

    public void setAlterMap(Map<String, String> alterMap) {
        this.alterMap = alterMap;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Map<String, String> getTagsMap() {
        return this.tagsMap;
    }

    public void setTagsMap(Map<String, String> tagsMap) {
        this.tagsMap = tagsMap;
    }

    public Map<String, String> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttributesMap(Map<String, String> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public boolean isAlterView() {
        return this.isAlterView;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitAlterTimeseries(this, context);
    }

    public static enum AlterType {
        RENAME,
        SET,
        DROP,
        ADD_TAGS,
        ADD_ATTRIBUTES,
        UPSERT;

    }
}

