/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DevicesCountNode
extends SchemaQueryScanNode {
    public DevicesCountNode(PlanNodeId id, PartialPath partialPath, boolean isPrefixPath) {
        super(id, partialPath, isPrefixPath);
    }

    @Override
    public PlanNode clone() {
        return new DevicesCountNode(this.getPlanNodeId(), this.path, this.isPrefixPath);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.countDevicesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.DEVICES_COUNT.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.DEVICES_COUNT.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize DevicesSchemaScanNode", e);
        }
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new DevicesCountNode(planNodeId, path, isPrefixPath);
    }

    @Override
    public String toString() {
        return String.format("DeviceCountNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

