/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.load;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.WritePlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.load.LoadSingleTsFileNode;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.tsfile.exception.NotImplementedException;

public class LoadTsFileNode
extends WritePlanNode {
    private final List<TsFileResource> resources;

    public LoadTsFileNode(PlanNodeId id, List<TsFileResource> resources) {
        super(id);
        this.resources = resources;
    }

    @Override
    public TRegionReplicaSet getRegionReplicaSet() {
        return null;
    }

    @Override
    public List<PlanNode> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public void addChild(PlanNode child) {
    }

    @Override
    public PlanNode clone() {
        throw new NotImplementedException("clone of load TsFile is not implemented");
    }

    @Override
    public int allowedChildCount() {
        return 0;
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.emptyList();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
    }

    @Override
    public List<WritePlanNode> splitByPartition(Analysis analysis) {
        ArrayList<WritePlanNode> res = new ArrayList<WritePlanNode>();
        LoadTsFileStatement statement = (LoadTsFileStatement)analysis.getStatement();
        for (TsFileResource resource : this.resources) {
            res.add(new LoadSingleTsFileNode(this.getPlanNodeId(), resource, statement.isDeleteAfterLoad()));
        }
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadTsFileNode loadTsFileNode = (LoadTsFileNode)o;
        return Objects.equals(this.resources, loadTsFileNode.resources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.resources);
    }
}

