/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.async.AsyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.client.sync.SyncDataNodeInternalServiceClient;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.query.KilledByOthersException;
import org.apache.iotdb.db.exception.query.QueryTimeoutRuntimeException;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.execution.QueryState;
import org.apache.iotdb.db.queryengine.execution.QueryStateMachine;
import org.apache.iotdb.db.queryengine.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.queryengine.execution.exchange.source.ISourceHandle;
import org.apache.iotdb.db.queryengine.execution.exchange.source.SourceHandle;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.Analyzer;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.execution.memory.MemorySourceHandle;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceContext;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceVisitor;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.DistributionPlanner;
import org.apache.iotdb.db.queryengine.plan.planner.plan.DistributedQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeUtil;
import org.apache.iotdb.db.queryengine.plan.scheduler.ClusterScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.IScheduler;
import org.apache.iotdb.db.queryengine.plan.scheduler.load.LoadTsFileScheduler;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.LoadTsFileStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.PipeEnrichedLoadTsFileStatement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.mpp.rpc.thrift.TFragmentInstanceId;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecution
implements IQueryExecution {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecution.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int MAX_RETRY_COUNT = 3;
    private static final long RETRY_INTERVAL_IN_MS = 2000L;
    private int retryCount = 0;
    private final MPPQueryContext context;
    private IScheduler scheduler;
    private final QueryStateMachine stateMachine;
    private final List<PlanOptimizer> planOptimizers;
    private final Statement rawStatement;
    private Analysis analysis;
    private LogicalQueryPlan logicalPlan;
    private DistributedQueryPlan distributedPlan;
    private final ExecutorService executor;
    private final ExecutorService writeOperationExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private ISourceHandle resultHandle;
    private final AtomicBoolean resultHandleCleanUp;
    private final IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager;
    private final IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager;
    private final AtomicBoolean stopped;
    private long totalExecutionTime = 0L;
    private static final QueryExecutionMetricSet QUERY_EXECUTION_METRIC_SET = QueryExecutionMetricSet.getInstance();
    private static final QueryPlanCostMetricSet QUERY_PLAN_COST_METRIC_SET = QueryPlanCostMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public QueryExecution(Statement statement, MPPQueryContext context, ExecutorService executor, ExecutorService writeOperationExecutor, ScheduledExecutorService scheduledExecutor, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, IClientManager<TEndPoint, SyncDataNodeInternalServiceClient> syncInternalServiceClientManager, IClientManager<TEndPoint, AsyncDataNodeInternalServiceClient> asyncInternalServiceClientManager) {
        this.rawStatement = statement;
        this.executor = executor;
        this.writeOperationExecutor = writeOperationExecutor;
        this.scheduledExecutor = scheduledExecutor;
        this.context = context;
        this.planOptimizers = new ArrayList<PlanOptimizer>();
        this.analysis = this.analyze(statement, context, partitionFetcher, schemaFetcher);
        this.stateMachine = new QueryStateMachine(context.getQueryId(), executor);
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.syncInternalServiceClientManager = syncInternalServiceClientManager;
        this.asyncInternalServiceClientManager = asyncInternalServiceClientManager;
        this.stateMachine.addStateChangeListener(state -> {
            try (SetThreadName queryName = new SetThreadName(context.getQueryId().getId());){
                if (!state.isDone()) {
                    return;
                }
                if (state == QueryState.FAILED || state == QueryState.ABORTED || state == QueryState.CANCELED) {
                    logger.debug("[ReleaseQueryResource] state is: {}", (Object)state);
                    Throwable cause = this.stateMachine.getFailureException();
                    this.releaseResource(cause);
                }
                this.stop(null);
            }
        });
        this.stopped = new AtomicBoolean(false);
        this.resultHandleCleanUp = new AtomicBoolean(false);
    }

    @Override
    public void start() {
        long startTime = System.nanoTime();
        if (this.skipExecute()) {
            logger.debug("[SkipExecute]");
            if (this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed()) {
                this.stateMachine.transitionToFailed(this.analysis.getFailStatus());
            } else {
                this.constructResultForMemorySource();
                this.stateMachine.transitionToRunning();
            }
            return;
        }
        this.checkTimeOutForQuery();
        this.doLogicalPlan();
        this.doDistributedPlan();
        this.context.setTimeOut(this.context.getTimeOut() - (System.currentTimeMillis() - this.context.getStartTime()));
        this.stateMachine.transitionToPlanned();
        if (this.context.getQueryType() == QueryType.READ) {
            this.initResultHandle();
        }
        PERFORMANCE_OVERVIEW_METRICS.recordPlanCost(System.nanoTime() - startTime);
        this.schedule();
        if (this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed()) {
            this.stateMachine.transitionToFailed(this.analysis.getFailStatus());
        }
    }

    private void checkTimeOutForQuery() {
        long currentTime;
        if (this.isQuery() && (currentTime = System.currentTimeMillis()) - this.context.getStartTime() >= this.context.getTimeOut()) {
            throw new QueryTimeoutRuntimeException(this.context.getStartTime(), currentTime, this.context.getTimeOut());
        }
    }

    private ExecutionResult retry() {
        if (this.retryCount >= 3) {
            logger.warn("[ReachMaxRetryCount]");
            this.stateMachine.transitionToFailed();
            return this.getStatus();
        }
        logger.warn("error when executing query. {}", (Object)this.stateMachine.getFailureMessage());
        this.stopAndCleanup(this.stateMachine.getFailureException());
        logger.info("[WaitBeforeRetry] wait {}ms.", (Object)2000L);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.warn("interrupted when waiting retry");
            Thread.currentThread().interrupt();
        }
        ++this.retryCount;
        logger.info("[Retry] retry count is: {}", (Object)this.retryCount);
        this.stateMachine.transitionToQueued();
        this.partitionFetcher.invalidAllCache();
        this.context.prepareForRetry();
        this.stopped.compareAndSet(true, false);
        this.resultHandleCleanUp.compareAndSet(true, false);
        this.analysis = this.analyze(this.rawStatement, this.context, this.partitionFetcher, this.schemaFetcher);
        this.start();
        return this.getStatus();
    }

    private boolean skipExecute() {
        return this.analysis.isFinishQueryAfterAnalyze() || this.context.getQueryType() == QueryType.READ && !this.analysis.hasDataSource();
    }

    private void constructResultForMemorySource() {
        StatementMemorySource memorySource = (StatementMemorySource)new StatementMemorySourceVisitor().process(this.analysis.getStatement(), new StatementMemorySourceContext(this.context, this.analysis));
        this.resultHandle = new MemorySourceHandle(memorySource.getTsBlock());
        this.analysis.setRespDatasetHeader(memorySource.getDatasetHeader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Analysis analyze(Statement statement, MPPQueryContext context, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        Analysis result;
        long startTime = System.nanoTime();
        try {
            result = new Analyzer(context, partitionFetcher, schemaFetcher).analyze(statement);
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordAnalyzeCost(System.nanoTime() - startTime);
        }
        return result;
    }

    private void schedule() {
        long startTime = System.nanoTime();
        if (this.rawStatement instanceof LoadTsFileStatement) {
            this.scheduler = new LoadTsFileScheduler(this.distributedPlan, this.context, this.stateMachine, this.syncInternalServiceClientManager, this.partitionFetcher, this.rawStatement instanceof PipeEnrichedLoadTsFileStatement);
            this.scheduler.start();
            return;
        }
        this.scheduler = new ClusterScheduler(this.context, this.stateMachine, this.distributedPlan.getInstances(), this.context.getQueryType(), this.executor, this.writeOperationExecutor, this.scheduledExecutor, this.syncInternalServiceClientManager, this.asyncInternalServiceClientManager);
        this.scheduler.start();
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleCost(System.nanoTime() - startTime);
    }

    public void doLogicalPlan() {
        LogicalPlanner planner = new LogicalPlanner(this.context, this.planOptimizers);
        this.logicalPlan = planner.plan(this.analysis);
        if (this.isQuery() && logger.isDebugEnabled()) {
            logger.debug("logical plan is: \n {}", (Object)PlanNodeUtil.nodeToString(this.logicalPlan.getRootNode()));
        }
        this.checkTimeOutForQuery();
    }

    public void doDistributedPlan() {
        long startTime = System.nanoTime();
        DistributionPlanner planner = new DistributionPlanner(this.analysis, this.logicalPlan);
        this.distributedPlan = planner.planFragments();
        if (this.rawStatement.isQuery()) {
            QUERY_PLAN_COST_METRIC_SET.recordPlanCost("distribution_planner", System.nanoTime() - startTime);
        }
        if (this.isQuery() && logger.isDebugEnabled()) {
            logger.debug("distribution plan done. Fragment instance count is {}, details is: \n {}", (Object)this.distributedPlan.getInstances().size(), (Object)this.printFragmentInstances(this.distributedPlan.getInstances()));
        }
        this.checkTimeOutForQuery();
    }

    private String printFragmentInstances(List<FragmentInstance> instances) {
        StringBuilder ret = new StringBuilder();
        for (FragmentInstance instance : instances) {
            ret.append(System.lineSeparator()).append(instance);
        }
        return ret.toString();
    }

    @Override
    public void stop(Throwable t) {
        if (this.stopped.compareAndSet(false, true) && this.scheduler != null) {
            this.scheduler.stop(t);
        }
    }

    @Override
    public void stopAndCleanup() {
        this.stop(null);
        this.releaseResource();
    }

    @Override
    public void cancel() {
        this.stateMachine.transitionToCanceled((Throwable)((Object)new KilledByOthersException()), new TSStatus(TSStatusCode.QUERY_WAS_KILLED.getStatusCode()).setMessage("Query was killed by others"));
    }

    private void releaseResource() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.cleanUpResultHandle();
        }
    }

    private void cleanUpResultHandle() {
        if (this.resultHandleCleanUp.compareAndSet(false, true) && this.resultHandle instanceof SourceHandle) {
            TFragmentInstanceId fragmentInstanceId = this.resultHandle.getLocalFragmentInstanceId();
            MPPDataExchangeService.getInstance().getMPPDataExchangeManager().deRegisterFragmentInstanceFromMemoryPool(fragmentInstanceId.queryId, FragmentInstanceId.createFragmentInstanceIdFromTFragmentInstanceId(fragmentInstanceId));
        }
    }

    @Override
    public void stopAndCleanup(Throwable t) {
        this.stop(t);
        this.releaseResource(t);
    }

    private void releaseResource(Throwable t) {
        if (this.resultHandle != null) {
            if (t != null) {
                this.resultHandle.abort(t);
            } else {
                this.resultHandle.close();
            }
            this.cleanUpResultHandle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Optional<T> getResult(ISourceHandleSupplier<T> dataSupplier) throws IoTDBException {
        Preconditions.checkArgument((this.resultHandle != null ? 1 : 0) != 0, (Object)"ResultHandle in Coordinator should be init firstly.");
        while (true) {
            try {
                block13: {
                    T res;
                    do {
                        if (this.resultHandle.isAborted()) {
                            logger.warn("[ResultHandleAborted]");
                            this.stateMachine.transitionToAborted();
                            if (this.stateMachine.getFailureStatus() != null) {
                                throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
                            }
                            throw new IoTDBException(this.stateMachine.getFailureMessage(), TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
                        }
                        if (this.resultHandle.isFinished()) {
                            logger.debug("[ResultHandleFinished]");
                            this.stateMachine.transitionToFinished();
                            return Optional.empty();
                        }
                        long startTime = System.nanoTime();
                        try {
                            ListenableFuture<?> blocked = this.resultHandle.isBlocked();
                            blocked.get();
                        }
                        finally {
                            QUERY_EXECUTION_METRIC_SET.recordExecutionCost("wait_for_result", System.nanoTime() - startTime);
                        }
                        if (this.resultHandle.isFinished()) break block13;
                    } while ((res = dataSupplier.get()) == null);
                    return Optional.of(res);
                }
                return Optional.empty();
            }
            catch (CancellationException | ExecutionException e) {
                this.dealWithException(e.getCause() != null ? e.getCause() : e);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.dealWithException(e);
                continue;
            }
            catch (Throwable t) {
                this.dealWithException(t);
                continue;
            }
            break;
        }
    }

    private void dealWithException(Throwable t) throws IoTDBException {
        this.stateMachine.transitionToFailed(t);
        if (this.stateMachine.getFailureStatus() != null) {
            throw new IoTDBException(this.stateMachine.getFailureStatus().getMessage(), this.stateMachine.getFailureStatus().code);
        }
        if (this.stateMachine.getFailureException() != null) {
            Throwable rootCause = this.stateMachine.getFailureException();
            throw new IoTDBException(rootCause, TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
        }
        Throwables.throwIfUnchecked((Throwable)t);
        throw new IoTDBException(t, TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
    }

    @Override
    public Optional<TsBlock> getBatchResult() throws IoTDBException {
        return this.getResult(this::getDeserializedTsBlock);
    }

    private TsBlock getDeserializedTsBlock() {
        return this.resultHandle.receive();
    }

    @Override
    public Optional<ByteBuffer> getByteBufferBatchResult() throws IoTDBException {
        return this.getResult(this::getSerializedTsBlock);
    }

    private ByteBuffer getSerializedTsBlock() throws IoTDBException {
        return this.resultHandle.getSerializedTsBlock();
    }

    @Override
    public boolean hasNextResult() {
        return this.resultHandle != null && !this.resultHandle.isFinished();
    }

    @Override
    public int getOutputValueColumnCount() {
        return this.analysis.getRespDatasetHeader().getOutputValueColumnCount();
    }

    @Override
    public DatasetHeader getDatasetHeader() {
        return this.analysis.getRespDatasetHeader();
    }

    @Override
    public ExecutionResult getStatus() {
        try {
            if (this.stateMachine.getState() == QueryState.FINISHED) {
                return this.getExecutionResult(QueryState.FINISHED);
            }
            SettableFuture future = SettableFuture.create();
            this.stateMachine.addStateChangeListener(state -> {
                if (state == QueryState.RUNNING || state.isDone() || state == QueryState.PENDING_RETRY) {
                    future.set((Object)state);
                }
            });
            QueryState state2 = (QueryState)((Object)future.get());
            if (state2 == QueryState.PENDING_RETRY) {
                return this.retry();
            }
            return this.getExecutionResult(state2);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new ExecutionResult(this.context.getQueryId(), this.stateMachine.getFailureStatus() == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)this.stateMachine.getFailureMessage()) : this.stateMachine.getFailureStatus());
        }
        catch (ExecutionException e) {
            return new ExecutionResult(this.context.getQueryId(), this.stateMachine.getFailureStatus() == null ? RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)this.stateMachine.getFailureMessage()) : this.stateMachine.getFailureStatus());
        }
    }

    private void initResultHandle() {
        TEndPoint upstreamEndPoint = this.context.getResultNodeContext().getUpStreamEndpoint();
        this.resultHandle = DataNodeEndPoints.isSameNode(upstreamEndPoint) ? MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createLocalSourceHandleForFragment(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), this.context.getResultNodeContext().getUpStreamPlanNodeId().getId(), this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), 0, this.stateMachine::transitionToFailed) : MPPDataExchangeService.getInstance().getMPPDataExchangeManager().createSourceHandle(this.context.getResultNodeContext().getVirtualFragmentInstanceId().toThrift(), this.context.getResultNodeContext().getVirtualResultNodeId().getId(), 0, upstreamEndPoint, this.context.getResultNodeContext().getUpStreamFragmentInstanceId().toThrift(), this.stateMachine::transitionToFailed);
    }

    private ExecutionResult getExecutionResult(QueryState state) {
        TSStatusCode statusCode = this.context.getQueryType() == QueryType.WRITE && this.analysis.isFailed() ? (state == QueryState.FINISHED ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.WRITE_PROCESS_ERROR) : (state == QueryState.FINISHED || state == QueryState.RUNNING ? TSStatusCode.SUCCESS_STATUS : TSStatusCode.EXECUTE_STATEMENT_ERROR);
        TSStatus tsstatus = RpcUtils.getStatus((TSStatusCode)statusCode, (String)(statusCode == TSStatusCode.SUCCESS_STATUS ? "" : this.stateMachine.getFailureMessage()));
        if (state.isDone() && this.stateMachine.getFailureStatus() != null) {
            tsstatus = this.stateMachine.getFailureStatus();
        }
        if (this.analysis.getStatement() instanceof InsertBaseStatement && !this.analysis.isFinishQueryAfterAnalyze() && (!config.isEnable13DataInsertAdapt() || IoTDBConstant.ClientVersion.V_1_0.equals((Object)this.context.getSession().getVersion()))) {
            InsertBaseStatement insertStatement = (InsertBaseStatement)this.analysis.getStatement();
            List<TEndPoint> redirectNodeList = this.analysis.getRedirectNodeList();
            if (insertStatement instanceof InsertRowsStatement || insertStatement instanceof InsertMultiTabletsStatement) {
                if (statusCode == TSStatusCode.SUCCESS_STATUS) {
                    boolean needRedirect = false;
                    ArrayList<TSStatus> subStatus = new ArrayList<TSStatus>();
                    for (TEndPoint endPoint : redirectNodeList) {
                        if (!config.getAddressAndPort().equals(endPoint)) {
                            subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS).setRedirectNode(endPoint));
                            needRedirect = true;
                            continue;
                        }
                        subStatus.add(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
                    }
                    if (needRedirect) {
                        tsstatus.setCode(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
                        tsstatus.setSubStatus(subStatus);
                    }
                }
            } else {
                TEndPoint redirectEndPoint = redirectNodeList.get(0);
                if (!config.getAddressAndPort().equals(redirectEndPoint)) {
                    tsstatus.setRedirectNode(redirectEndPoint);
                }
            }
        }
        return new ExecutionResult(this.context.getQueryId(), tsstatus);
    }

    public DistributedQueryPlan getDistributedPlan() {
        return this.distributedPlan;
    }

    public LogicalQueryPlan getLogicalPlan() {
        return this.logicalPlan;
    }

    @Override
    public boolean isQuery() {
        return this.context.getQueryType() == QueryType.READ;
    }

    @Override
    public String getQueryId() {
        return this.context.getQueryId().getId();
    }

    @Override
    public long getStartExecutionTime() {
        return this.context.getStartTime();
    }

    @Override
    public void recordExecutionTime(long executionTime) {
        this.totalExecutionTime += executionTime;
    }

    @Override
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Override
    public Optional<String> getExecuteSQL() {
        return Optional.ofNullable(this.context.getSql());
    }

    @Override
    public Statement getStatement() {
        return this.analysis.getStatement();
    }

    public String toString() {
        return String.format("QueryExecution[%s]", this.context.getQueryId());
    }

    @FunctionalInterface
    static interface ISourceHandleSupplier<T> {
        public T get() throws IoTDBException;
    }
}

