/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class SchemaFetchMergeOperator
implements ProcessOperator {
    private final OperatorContext operatorContext;
    private final List<Operator> children;
    private final int childrenCount;
    private int currentIndex;
    private boolean isReadingStorageGroupInfo;
    private final List<String> storageGroupList;

    public SchemaFetchMergeOperator(OperatorContext operatorContext, List<Operator> children, List<String> storageGroupList) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.childrenCount = children.size();
        this.currentIndex = 0;
        this.isReadingStorageGroupInfo = true;
        this.storageGroupList = storageGroupList;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() throws Exception {
        if (this.isReadingStorageGroupInfo) {
            this.isReadingStorageGroupInfo = false;
            return this.generateStorageGroupInfo();
        }
        if (this.children.get(this.currentIndex).hasNextWithTimer()) {
            return this.children.get(this.currentIndex).nextWithTimer();
        }
        ++this.currentIndex;
        return null;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.isReadingStorageGroupInfo || this.currentIndex < this.childrenCount;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.isReadingStorageGroupInfo || this.currentIndex >= this.children.size() ? NOT_BLOCKED : this.children.get(this.currentIndex).isBlocked();
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public void close() throws Exception {
        for (Operator child : this.children) {
            child.close();
        }
    }

    private TsBlock generateStorageGroupInfo() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)this.storageGroupList.size(), (OutputStream)outputStream);
            for (String storageGroup : this.storageGroupList) {
                ReadWriteIOUtils.write((String)storageGroup, (OutputStream)outputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new TsBlock(new TimeColumn(1, new long[]{0L}), new Column[]{new BinaryColumn(1, Optional.empty(), new Binary[]{new Binary(outputStream.toByteArray())})});
    }

    @Override
    public long calculateMaxPeekMemory() {
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
        }
        return childrenMaxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long childrenMaxReturnSize = 0L;
        for (Operator child : this.children) {
            childrenMaxReturnSize = Math.max(childrenMaxReturnSize, child.calculateMaxReturnSize());
        }
        return childrenMaxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.children) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }
}

