/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeConnectorCriticalException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.execution.scheduler.PipeSubtaskScheduler;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.connection.PipeEventCollector;
import org.apache.iotdb.db.pipe.task.subtask.DecoratingLock;
import org.apache.iotdb.db.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConnectorSubtask
extends PipeSubtask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConnectorSubtask.class);
    private final BoundedBlockingPendingQueue<Event> inputPendingQueue;
    private final PipeConnector outputPipeConnector;
    protected final DecoratingLock callbackDecoratingLock = new DecoratingLock();
    protected ExecutorService subtaskCallbackListeningExecutor;

    public PipeConnectorSubtask(String taskID, BoundedBlockingPendingQueue<Event> inputPendingQueue, PipeConnector outputPipeConnector) {
        super(taskID);
        this.inputPendingQueue = inputPendingQueue;
        this.outputPipeConnector = outputPipeConnector;
    }

    @Override
    public void bindExecutors(ListeningExecutorService subtaskWorkerThreadPoolExecutor, ExecutorService subtaskCallbackListeningExecutor, PipeSubtaskScheduler subtaskScheduler) {
        this.subtaskWorkerThreadPoolExecutor = subtaskWorkerThreadPoolExecutor;
        this.subtaskCallbackListeningExecutor = subtaskCallbackListeningExecutor;
        this.subtaskScheduler = subtaskScheduler;
    }

    @Override
    public Boolean call() throws Exception {
        boolean hasAtLeastOneEventProcessed = super.call();
        this.callbackDecoratingLock.waitForDecorated();
        return hasAtLeastOneEventProcessed;
    }

    @Override
    protected synchronized boolean executeOnce() {
        Object event;
        this.lastEvent = event = this.lastEvent != null ? this.lastEvent : this.inputPendingQueue.waitedPoll();
        if (event == null) {
            return false;
        }
        try {
            if (event instanceof TabletInsertionEvent) {
                this.outputPipeConnector.transfer((TabletInsertionEvent)event);
            } else if (event instanceof TsFileInsertionEvent) {
                this.outputPipeConnector.transfer((TsFileInsertionEvent)event);
            } else if (event instanceof PipeHeartbeatEvent) {
                try {
                    this.outputPipeConnector.heartbeat();
                    this.outputPipeConnector.transfer(event);
                }
                catch (Exception e) {
                    throw new PipeConnectionException("PipeConnector: " + this.outputPipeConnector.getClass().getName() + " heartbeat failed", (Throwable)e);
                }
                ((PipeHeartbeatEvent)event).onTransferred();
            } else {
                this.outputPipeConnector.transfer(event);
            }
            this.releaseLastEvent(true);
        }
        catch (PipeConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeException("Error occurred during executing PipeConnector#transfer, perhaps need to check whether the implementation of PipeConnector is correct according to the pipe-api description.", (Throwable)e);
        }
        return true;
    }

    @Override
    public void onFailure(@NotNull Throwable throwable) {
        if (throwable instanceof PipeConnectionException) {
            LOGGER.warn("PipeConnectionException occurred, retrying to connect to the target system...", throwable);
            int retry = 0;
            while (retry < 5) {
                try {
                    this.outputPipeConnector.handshake();
                    LOGGER.info("Successfully reconnected to the target system.");
                    break;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to reconnect to the target system, retrying ... after [{}/{}] time(s) retries.", new Object[]{++retry, 5, e});
                    try {
                        Thread.sleep((long)retry * PipeConfig.getInstance().getPipeConnectorRetryIntervalMs());
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.info("Interrupted while sleeping, perhaps need to check whether the thread is interrupted.", (Throwable)interruptedException);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (retry == 5) {
                if (this.lastEvent instanceof EnrichedEvent) {
                    LOGGER.warn("Failed to reconnect to the target system after {} times, stopping current pipe task {}... Status shown when query the pipe will be 'STOPPED'. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{5, this.taskID, throwable});
                    ((EnrichedEvent)this.lastEvent).reportException((PipeRuntimeException)new PipeRuntimeConnectorCriticalException(throwable.getMessage() + ", root cause: " + ErrorHandlingUtils.getRootCause(throwable).getMessage()));
                } else {
                    LOGGER.error("Failed to reconnect to the target system after {} times, stopping current pipe task {} locally... Status shown when query the pipe will be 'RUNNING' instead of 'STOPPED', but the task is actually stopped. Please restart the task by executing 'START PIPE' manually if needed.", new Object[]{5, this.taskID, throwable});
                }
                return;
            }
        } else {
            LOGGER.warn("A non-PipeConnectionException occurred, exception message: {}", (Object)throwable.getMessage(), (Object)throwable);
        }
        super.onFailure((Throwable)new PipeRuntimeConnectorCriticalException(throwable.getMessage()));
    }

    @Override
    public void submitSelf() {
        if (this.shouldStopSubmittingSelf.get()) {
            return;
        }
        this.callbackDecoratingLock.markAsDecorating();
        try {
            ListenableFuture nextFuture = this.subtaskWorkerThreadPoolExecutor.submit((Callable)this);
            Futures.addCallback((ListenableFuture)nextFuture, (FutureCallback)this, (Executor)this.subtaskCallbackListeningExecutor);
        }
        finally {
            this.callbackDecoratingLock.markAsDecorated();
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.outputPipeConnector.close();
        }
        catch (Exception e) {
            LOGGER.info("Error occurred during closing PipeConnector, perhaps need to check whether the implementation of PipeConnector is correct according to the pipe-api description.", (Throwable)e);
        }
        finally {
            this.inputPendingQueue.forEach(event -> {
                if (event instanceof EnrichedEvent) {
                    ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
                }
            });
            this.inputPendingQueue.clear();
            super.close();
        }
    }
}

