/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.realtime;

import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeNonCriticalException;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.realtime.PipeRealtimeEvent;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.PipeRealtimeDataRegionLogExtractor;
import org.apache.iotdb.db.pipe.extractor.realtime.epoch.TsFileEpoch;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeRealtimeDataRegionHybridExtractor
extends PipeRealtimeDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeRealtimeDataRegionHybridExtractor.class);

    @Override
    protected void doExtract(PipeRealtimeEvent event) {
        EnrichedEvent eventToExtract = event.getEvent();
        if (eventToExtract instanceof TabletInsertionEvent) {
            this.extractTabletInsertion(event);
        } else if (eventToExtract instanceof TsFileInsertionEvent) {
            this.extractTsFileInsertion(event);
        } else if (eventToExtract instanceof PipeHeartbeatEvent) {
            this.extractHeartbeat(event);
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s", eventToExtract.getClass(), this));
        }
    }

    @Override
    public boolean isNeedListenToTsFile() {
        return true;
    }

    @Override
    public boolean isNeedListenToInsertNode() {
        return true;
    }

    private void extractTabletInsertion(PipeRealtimeEvent event) {
        if (this.isApproachingCapacity()) {
            event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
        }
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TSFILE: {
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            case EMPTY: 
            case USING_TABLET: {
                if (this.pendingQueue.waitedOffer(event)) break;
                String errorMessage = String.format("extractTabletInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard tablet event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state2, PipeRealtimeDataRegionHybridExtractor.class.getName()}));
            }
        }
    }

    private void extractTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> state.equals((Object)TsFileEpoch.State.EMPTY) ? TsFileEpoch.State.USING_TSFILE : state);
        TsFileEpoch.State state2 = event.getTsFileEpoch().getState(this);
        switch (state2) {
            case USING_TSFILE: 
            case EMPTY: {
                if (this.pendingQueue.waitedOffer(event)) break;
                String errorMessage = String.format("extractTsFileInsertion: pending queue of PipeRealtimeDataRegionHybridExtractor %s has reached capacity, discard TsFile event %s, current state %s", new Object[]{this, event, event.getTsFileEpoch().getState(this)});
                LOGGER.error(errorMessage);
                PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
                break;
            }
            case USING_TABLET: {
                event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported state %s for hybrid realtime extractor %s", new Object[]{state2, PipeRealtimeDataRegionHybridExtractor.class.getName()}));
            }
        }
    }

    private void extractHeartbeat(PipeRealtimeEvent event) {
        ((PipeHeartbeatEvent)event.getEvent()).recordExtractorQueueSize(this.pendingQueue);
        Object lastEvent = this.pendingQueue.peekLast();
        if (lastEvent instanceof PipeRealtimeEvent && ((PipeRealtimeEvent)lastEvent).getEvent() instanceof PipeHeartbeatEvent && (((PipeHeartbeatEvent)((PipeRealtimeEvent)lastEvent).getEvent()).isShouldPrintMessage() || !((PipeHeartbeatEvent)event.getEvent()).isShouldPrintMessage())) {
            event.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            LOGGER.error("extract: pending queue of PipeRealtimeDataRegionHybridExtractor {} has reached capacity, discard heartbeat event {}", (Object)this, (Object)event);
            event.decreaseReferenceCount(PipeRealtimeDataRegionLogExtractor.class.getName(), false);
        }
    }

    private boolean isApproachingCapacity() {
        return this.pendingQueue.size() >= PipeConfig.getInstance().getPipeExtractorPendingQueueTabletLimit();
    }

    public Event supply() {
        PipeRealtimeEvent realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        while (realtimeEvent != null) {
            Event suppliedEvent;
            EnrichedEvent eventToSupply = realtimeEvent.getEvent();
            if (eventToSupply instanceof TabletInsertionEvent) {
                suppliedEvent = this.supplyTabletInsertion(realtimeEvent);
            } else if (eventToSupply instanceof TsFileInsertionEvent) {
                suppliedEvent = this.supplyTsFileInsertion(realtimeEvent);
            } else if (eventToSupply instanceof PipeHeartbeatEvent) {
                suppliedEvent = this.supplyHeartbeat(realtimeEvent);
            } else {
                throw new UnsupportedOperationException(String.format("Unsupported event type %s for hybrid realtime extractor %s to supply.", eventToSupply.getClass(), this));
            }
            realtimeEvent.decreaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName(), false);
            if (suppliedEvent != null) {
                return suppliedEvent;
            }
            realtimeEvent = (PipeRealtimeEvent)this.pendingQueue.directPoll();
        }
        return null;
    }

    private Event supplyTabletInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> state.equals((Object)TsFileEpoch.State.EMPTY) ? TsFileEpoch.State.USING_TABLET : state);
        if (event.getTsFileEpoch().getState(this).equals((Object)TsFileEpoch.State.USING_TABLET)) {
            if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
                return event.getEvent();
            }
            event.getTsFileEpoch().migrateState(this, state -> TsFileEpoch.State.USING_TSFILE);
            LOGGER.warn("Discard tablet event {} because it is not reliable anymore. Change the state of TsFileEpoch to USING_TSFILE.", (Object)event);
            return null;
        }
        return null;
    }

    private Event supplyTsFileInsertion(PipeRealtimeEvent event) {
        event.getTsFileEpoch().migrateState(this, state -> {
            if (state.equals((Object)TsFileEpoch.State.EMPTY)) {
                LOGGER.error(String.format("EMPTY TsFileEpoch when supplying TsFile Event %s", event));
                return TsFileEpoch.State.USING_TSFILE;
            }
            return state;
        });
        if (event.getTsFileEpoch().getState(this).equals((Object)TsFileEpoch.State.USING_TSFILE)) {
            if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
                return event.getEvent();
            }
            String errorMessage = String.format("TsFile Event %s can not be supplied because the reference count can not be increased, the data represented by this event is lost", event.getEvent());
            LOGGER.error(errorMessage);
            PipeAgent.runtime().report(this.pipeTaskMeta, (PipeRuntimeException)new PipeRuntimeNonCriticalException(errorMessage));
            return null;
        }
        return null;
    }

    private Event supplyHeartbeat(PipeRealtimeEvent event) {
        if (event.increaseReferenceCount(PipeRealtimeDataRegionHybridExtractor.class.getName())) {
            return event.getEvent();
        }
        LOGGER.error("Heartbeat Event {} can not be supplied because the reference count can not be increased", (Object)event.getEvent());
        return null;
    }
}

