/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.PipeRequestType;
import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnectorRequestVersion;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import org.apache.iotdb.session.util.SessionUtils;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransferTabletRawReq
extends TPipeTransferReq {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTransferTabletRawReq.class);
    private transient Tablet tablet;
    private transient boolean isAligned;

    public Tablet getTablet() {
        return this.tablet;
    }

    public boolean getIsAligned() {
        return this.isAligned;
    }

    public InsertTabletStatement constructStatement() {
        if (!PipeTransferTabletRawReq.checkSorted(this.tablet)) {
            PipeTransferTabletRawReq.sortTablet(this.tablet);
        }
        try {
            TSInsertTabletReq request = new TSInsertTabletReq();
            for (IMeasurementSchema measurementSchema : this.tablet.getSchemas()) {
                request.addToMeasurements(measurementSchema.getMeasurementId());
                request.addToTypes(measurementSchema.getType().ordinal());
            }
            request.setPrefixPath(this.tablet.deviceId);
            request.setIsAligned(this.isAligned);
            request.setTimestamps(SessionUtils.getTimeBuffer((Tablet)this.tablet));
            request.setValues(SessionUtils.getValueBuffer((Tablet)this.tablet));
            request.setSize(this.tablet.rowSize);
            request.setMeasurements(PathUtils.checkIsLegalSingleMeasurementsAndUpdate((List)request.getMeasurements()));
            return StatementGenerator.createStatement(request);
        }
        catch (MetadataException e) {
            LOGGER.warn(String.format("Generate Statement from tablet %s error.", this.tablet), (Throwable)e);
            return null;
        }
    }

    private static boolean checkSorted(Tablet tablet) {
        for (int i = 1; i < tablet.rowSize; ++i) {
            if (tablet.timestamps[i] >= tablet.timestamps[i - 1]) continue;
            return false;
        }
        return true;
    }

    private static void sortTablet(Tablet tablet) {
        Integer[] index = new Integer[tablet.rowSize];
        for (int i = 0; i < tablet.rowSize; ++i) {
            index[i] = i;
        }
        Arrays.sort(index, Comparator.comparingLong(o -> tablet.timestamps[o]));
        Arrays.sort(tablet.timestamps, 0, tablet.rowSize);
        int columnIndex = 0;
        for (int i = 0; i < tablet.getSchemas().size(); ++i) {
            IMeasurementSchema schema = (IMeasurementSchema)tablet.getSchemas().get(i);
            if (schema == null) continue;
            tablet.values[columnIndex] = PipeTransferTabletRawReq.sortList(tablet.values[columnIndex], schema.getType(), index);
            if (tablet.bitMaps != null && tablet.bitMaps[columnIndex] != null) {
                tablet.bitMaps[columnIndex] = PipeTransferTabletRawReq.sortBitMap(tablet.bitMaps[columnIndex], index);
            }
            ++columnIndex;
        }
    }

    private static Object sortList(Object valueList, TSDataType dataType, Integer[] index) {
        switch (dataType) {
            case BOOLEAN: {
                boolean[] boolValues = (boolean[])valueList;
                boolean[] sortedValues = new boolean[boolValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedValues[i] = boolValues[index[i]];
                }
                return sortedValues;
            }
            case INT32: {
                int[] intValues = (int[])valueList;
                int[] sortedIntValues = new int[intValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedIntValues[i] = intValues[index[i]];
                }
                return sortedIntValues;
            }
            case INT64: {
                long[] longValues = (long[])valueList;
                long[] sortedLongValues = new long[longValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedLongValues[i] = longValues[index[i]];
                }
                return sortedLongValues;
            }
            case FLOAT: {
                float[] floatValues = (float[])valueList;
                float[] sortedFloatValues = new float[floatValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedFloatValues[i] = floatValues[index[i]];
                }
                return sortedFloatValues;
            }
            case DOUBLE: {
                double[] doubleValues = (double[])valueList;
                double[] sortedDoubleValues = new double[doubleValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedDoubleValues[i] = doubleValues[index[i]];
                }
                return sortedDoubleValues;
            }
            case TEXT: {
                Binary[] binaryValues = (Binary[])valueList;
                Binary[] sortedBinaryValues = new Binary[binaryValues.length];
                for (int i = 0; i < index.length; ++i) {
                    sortedBinaryValues[i] = binaryValues[index[i]];
                }
                return sortedBinaryValues;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", dataType));
    }

    private static BitMap sortBitMap(BitMap bitMap, Integer[] index) {
        BitMap sortedBitMap = new BitMap(bitMap.getSize());
        for (int i = 0; i < index.length; ++i) {
            if (!bitMap.isMarked(index[i].intValue())) continue;
            sortedBitMap.mark(i);
        }
        return sortedBitMap;
    }

    public static PipeTransferTabletRawReq toTPipeTransferReq(Tablet tablet, boolean isAligned) throws IOException {
        PipeTransferTabletRawReq tabletReq = new PipeTransferTabletRawReq();
        tabletReq.tablet = tablet;
        tabletReq.version = IoTDBConnectorRequestVersion.VERSION_1.getVersion();
        tabletReq.type = PipeRequestType.TRANSFER_TABLET_RAW.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            tablet.serialize(outputStream);
            ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
            tabletReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return tabletReq;
    }

    public static PipeTransferTabletRawReq fromTPipeTransferReq(TPipeTransferReq transferReq) {
        PipeTransferTabletRawReq tabletReq = new PipeTransferTabletRawReq();
        tabletReq.tablet = Tablet.deserialize((ByteBuffer)transferReq.body);
        tabletReq.isAligned = ReadWriteIOUtils.readBool((ByteBuffer)transferReq.body);
        tabletReq.version = transferReq.version;
        tabletReq.type = transferReq.type;
        tabletReq.body = transferReq.body;
        return tabletReq;
    }

    public static byte[] toTPipeTransferTabletBytes(Tablet tablet, boolean isAligned) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            byte[] byArray;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                ReadWriteIOUtils.write((byte)IoTDBConnectorRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_TABLET_RAW.getType(), (OutputStream)outputStream);
                tablet.serialize(outputStream);
                ReadWriteIOUtils.write((Boolean)isAligned, (OutputStream)outputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            return byArray;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PipeTransferTabletRawReq that = (PipeTransferTabletRawReq)((Object)obj);
        return this.tablet.equals((Object)that.tablet) && this.isAligned == that.isAligned && this.version == that.version && this.type == that.type && this.body.equals(that.body);
    }

    public int hashCode() {
        return Objects.hash(this.tablet, this.isAligned, this.version, this.type, this.body);
    }
}

