/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.builder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public abstract class PipeTransferBatchReqBuilder {
    protected final List<TPipeTransferReq> reqs = new ArrayList<TPipeTransferReq>();
    protected final List<Event> events = new ArrayList<Event>();
    protected final int maxDelayInMs;
    protected long firstEventProcessingTime = Long.MIN_VALUE;
    protected final long maxBatchSizeInBytes;
    protected long bufferSize = 0L;

    protected PipeTransferBatchReqBuilder(PipeParameters parameters) {
        this.maxDelayInMs = parameters.getIntOrDefault("connector.batch.max-delay-seconds", 1) * 1000;
        this.maxBatchSizeInBytes = parameters.getLongOrDefault("connector.batch.size-bytes", 0x1000000L);
    }

    public List<TPipeTransferReq> getTPipeTransferReqs() {
        return this.reqs;
    }

    public boolean isEmpty() {
        return this.reqs.isEmpty();
    }

    protected TPipeTransferReq buildTabletInsertionReq(TabletInsertionEvent event) throws IOException, WALPipeException {
        PipeTransferTabletRawReq req;
        if (event instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)event;
            req = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible() == null ? PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getInsertNode());
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)event;
            req = PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
        }
        return req;
    }
}

