/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.commons.schema.tree.ITreeNode;
import org.apache.iotdb.commons.utils.ThriftConfigNodeSerDeUtils;
import org.apache.iotdb.confignode.persistence.schema.ConfigMTreeStore;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.persistence.schema.mnode.factory.ConfigMNodeFactory;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.exception.metadata.DatabaseAlreadySetException;
import org.apache.iotdb.db.exception.metadata.DatabaseNotSetException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.schemaengine.SchemaConstant;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.DatabaseCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeAboveDBCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.collector.MNodeCollector;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.traverser.counter.DatabaseCounter;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MetaFormatUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMTree {
    private final Logger logger = LoggerFactory.getLogger(ConfigMTree.class);
    private IConfigMNode root;
    private final ConfigMTreeStore store;
    private final IMNodeFactory<IConfigMNode> nodeFactory = ConfigMNodeFactory.getInstance();

    public ConfigMTree() throws MetadataException {
        this.store = new ConfigMTreeStore(this.nodeFactory);
        this.root = this.store.getRoot();
    }

    public void clear() {
        if (this.store != null) {
            this.store.clear();
            this.root = this.store.getRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStorageGroup(PartialPath path) throws MetadataException {
        int i;
        String[] nodeNames = path.getNodes();
        MetaFormatUtils.checkDatabase((String)path.getFullPath());
        if (nodeNames.length <= 1 || !nodeNames[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (i = 1; i < nodeNames.length - 1; ++i) {
            IConfigMNode temp = this.store.getChild(cur, nodeNames[i]);
            if (temp == null) {
                this.store.addChild(cur, nodeNames[i], (IConfigMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            } else if (temp.isDatabase()) {
                throw new DatabaseAlreadySetException(temp.getFullPath());
            }
            cur = this.store.getChild(cur, nodeNames[i]);
        }
        ConfigMTree configMTree = this;
        synchronized (configMTree) {
            if (this.store.hasChild(cur, nodeNames[i])) {
                if (this.store.getChild(cur, nodeNames[i]).isDatabase()) {
                    throw new DatabaseAlreadySetException(path.getFullPath());
                }
                throw new DatabaseAlreadySetException(path.getFullPath(), true);
            }
            IDatabaseMNode databaseMNode = this.nodeFactory.createDatabaseMNode((IMNode)cur, nodeNames[i]);
            databaseMNode.setDataTTL(CommonDescriptor.getInstance().getConfig().getDefaultTTLInMs());
            IConfigMNode result = this.store.addChild(cur, nodeNames[i], (IConfigMNode)databaseMNode.getAsMNode());
            if (result != databaseMNode) {
                throw new DatabaseAlreadySetException(path.getFullPath(), true);
            }
        }
    }

    public void deleteDatabase(PartialPath path) throws MetadataException {
        IDatabaseMNode<IConfigMNode> databaseMNode = this.getDatabaseNodeByDatabasePath(path);
        IConfigMNode cur = (IConfigMNode)databaseMNode.getParent();
        this.store.deleteChild(cur, databaseMNode.getName());
        while (cur.getParent() != null && cur.getChildren().size() == 0) {
            ((IConfigMNode)cur.getParent()).deleteChild(cur.getName());
            cur = (IConfigMNode)cur.getParent();
        }
    }

    public List<PartialPath> getBelongedDatabases(PartialPath pathPattern) throws MetadataException {
        return this.collectDatabases(pathPattern, false, true);
    }

    public List<PartialPath> getMatchedDatabases(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.collectDatabases(pathPattern, isPrefixMatch, false);
    }

    private List<PartialPath> collectDatabases(PartialPath pathPattern, boolean isPrefixMatch, boolean collectInternal) throws MetadataException {
        final LinkedList<PartialPath> result = new LinkedList<PartialPath>();
        try (DatabaseCollector<List<PartialPath>, IConfigMNode> collector = new DatabaseCollector<List<PartialPath>, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch){

            protected void collectDatabase(IDatabaseMNode<IConfigMNode> node) {
                result.add(node.getPartialPath());
            }
        };){
            collector.setCollectInternal(collectInternal);
            collector.traverse();
        }
        return result;
    }

    public List<PartialPath> getAllDatabasePaths() {
        ArrayList<PartialPath> res = new ArrayList<PartialPath>();
        ArrayDeque<IConfigMNode> nodeStack = new ArrayDeque<IConfigMNode>();
        nodeStack.add(this.root);
        while (!nodeStack.isEmpty()) {
            IConfigMNode current = (IConfigMNode)nodeStack.pop();
            if (current.isDatabase()) {
                res.add(current.getPartialPath());
                continue;
            }
            nodeStack.addAll(current.getChildren().values());
        }
        return res;
    }

    public int getDatabaseNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        try (DatabaseCounter counter = new DatabaseCounter((IMNode)this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch);){
            int n = (int)counter.count();
            return n;
        }
    }

    public IDatabaseMNode<IConfigMNode> getDatabaseNodeByDatabasePath(PartialPath databasePath) throws MetadataException {
        String[] nodes = databasePath.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(databasePath.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodes.length - 1; ++i) {
            if ((cur = (IConfigMNode)cur.getChild(nodes[i])) == null) {
                throw new DatabaseNotSetException(databasePath.getFullPath());
            }
            if (!cur.isDatabase()) continue;
            throw new DatabaseAlreadySetException(cur.getFullPath());
        }
        if ((cur = (IConfigMNode)cur.getChild(nodes[nodes.length - 1])) == null) {
            throw new DatabaseNotSetException(databasePath.getFullPath());
        }
        if (cur.isDatabase()) {
            return cur.getAsDatabaseMNode();
        }
        throw new DatabaseAlreadySetException(databasePath.getFullPath(), true);
    }

    public IDatabaseMNode<IConfigMNode> getDatabaseNodeByPath(PartialPath path) throws MetadataException {
        String[] nodes = path.getNodes();
        if (nodes.length == 0 || !nodes[0].equals(this.root.getName())) {
            throw new IllegalPathException(path.getFullPath());
        }
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodes.length && (cur = (IConfigMNode)cur.getChild(nodes[i])) != null; ++i) {
            if (!cur.isDatabase()) continue;
            return cur.getAsDatabaseMNode();
        }
        throw new DatabaseNotSetException(path.getFullPath());
    }

    public boolean isDatabaseAlreadySet(PartialPath path) {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return false;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!this.store.hasChild(cur, nodeNames[i])) {
                return false;
            }
            if (!(cur = this.store.getChild(cur, nodeNames[i])).isDatabase()) continue;
            return true;
        }
        return true;
    }

    public void checkDatabaseAlreadySet(PartialPath path) throws DatabaseAlreadySetException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (!nodeNames[0].equals(this.root.getName())) {
            return;
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            if (!this.store.hasChild(cur, nodeNames[i])) {
                return;
            }
            if (!(cur = this.store.getChild(cur, nodeNames[i])).isDatabase()) continue;
            throw new DatabaseAlreadySetException(cur.getFullPath());
        }
        throw new DatabaseAlreadySetException(path.getFullPath(), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IConfigMNode getNodeWithAutoCreate(PartialPath path) throws DatabaseNotSetException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        boolean hasStorageGroup = false;
        for (int i = 1; i < nodeNames.length; ++i) {
            IConfigMNode child = this.store.getChild(cur, nodeNames[i]);
            if (child == null) {
                if (!hasStorageGroup) throw new DatabaseNotSetException(path.getFullPath());
                child = this.store.addChild(cur, nodeNames[i], (IConfigMNode)this.nodeFactory.createInternalMNode((IMNode)cur, nodeNames[i]));
            } else if (child.isDatabase()) {
                hasStorageGroup = true;
            }
            cur = child;
        }
        return cur;
    }

    public Pair<List<PartialPath>, Set<PartialPath>> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch) throws MetadataException {
        final LinkedList result = new LinkedList();
        try (MNodeAboveDBCollector<Void, IConfigMNode> collector = new MNodeAboveDBCollector<Void, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, isPrefixMatch){

            protected Void collectMNode(IConfigMNode node) {
                result.add(this.getPartialPathFromRootToNode((ITreeNode)node));
                return null;
            }
        };){
            collector.setTargetLevel(nodeLevel);
            collector.traverse();
            Pair pair = new Pair(result, (Object)collector.getInvolvedDatabaseMNodes());
            return pair;
        }
    }

    public Pair<Set<TSchemaNode>, Set<PartialPath>> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        Pair pair;
        final TreeSet result = new TreeSet();
        MNodeAboveDBCollector<Void, IConfigMNode> collector = new MNodeAboveDBCollector<Void, IConfigMNode>(this.root, pathPattern.concatNode("*"), (IMTreeStore)this.store, false){

            protected Void collectMNode(IConfigMNode node) {
                result.add(new TSchemaNode(this.getPartialPathFromRootToNode((ITreeNode)node).getFullPath(), node.getMNodeType(true).getNodeType()));
                return null;
            }
        };
        try {
            collector.traverse();
            pair = new Pair(result, (Object)collector.getInvolvedDatabaseMNodes());
        }
        catch (Throwable throwable) {
            try {
                try {
                    collector.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IllegalPathException e) {
                throw new IllegalPathException(pathPattern.getFullPath());
            }
        }
        collector.close();
        return pair;
    }

    public void checkTemplateOnPath(PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        if (cur.getSchemaTemplateId() != -1) {
            throw new MetadataException("Template already exists on " + cur.getFullPath());
        }
        for (int i = 1; i < nodeNames.length; ++i) {
            IConfigMNode child = (IConfigMNode)cur.getChild(nodeNames[i]);
            if (child == null) {
                return;
            }
            cur = child;
            if (cur.getSchemaTemplateId() != -1) {
                throw new MetadataException("Template already exists on " + cur.getFullPath());
            }
            if (!cur.isMeasurement()) continue;
            return;
        }
        this.checkTemplateOnSubtree(cur);
    }

    private void checkTemplateOnSubtree(IConfigMNode node) throws MetadataException {
        if (node.isMeasurement()) {
            return;
        }
        IMNodeIterator<IConfigMNode> iterator = this.store.getChildrenIterator(node);
        while (iterator.hasNext()) {
            IConfigMNode child = (IConfigMNode)iterator.next();
            if (child.isMeasurement()) continue;
            if (child.getSchemaTemplateId() != -1) {
                throw new MetadataException("Template already exists on " + child.getFullPath());
            }
            this.checkTemplateOnSubtree(child);
        }
    }

    public List<String> getPathsSetOnTemplate(final int templateId, final boolean filterPreUnset) throws MetadataException {
        final ArrayList<String> resSet = new ArrayList<String>();
        try (MNodeCollector<Void, IConfigMNode> collector = new MNodeCollector<Void, IConfigMNode>(this.root, new PartialPath(SchemaConstant.ALL_RESULT_NODES), (IMTreeStore)this.store, false){

            protected boolean acceptFullMatchedNode(IConfigMNode node) {
                if (super.acceptFullMatchedNode((IMNode)node) && node.getSchemaTemplateId() != -1) {
                    if (filterPreUnset && node.isSchemaTemplatePreUnset()) {
                        return false;
                    }
                    return templateId == -2 || templateId == node.getSchemaTemplateId();
                }
                return false;
            }

            protected Void collectMNode(IConfigMNode node) {
                resSet.add(node.getFullPath());
                return null;
            }

            protected boolean shouldVisitSubtreeOfFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }

            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }
        };){
            collector.traverse();
        }
        return resSet;
    }

    public Map<Integer, Set<PartialPath>> getTemplateSetInfo(PartialPath pathPattern) throws MetadataException {
        final HashMap<Integer, Set<PartialPath>> result = new HashMap<Integer, Set<PartialPath>>();
        try (MNodeCollector<Void, IConfigMNode> collector = new MNodeCollector<Void, IConfigMNode>(this.root, pathPattern, (IMTreeStore)this.store, false){

            protected boolean acceptFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptFullMatchedNode((IMNode)node);
            }

            protected boolean acceptInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() != -1 || super.acceptInternalMatchedNode((IMNode)node);
            }

            protected Void collectMNode(IConfigMNode node) {
                if (node.getSchemaTemplateId() != -1 && !node.isSchemaTemplatePreUnset()) {
                    result.computeIfAbsent(node.getSchemaTemplateId(), k -> new HashSet()).add(this.getPartialPathFromRootToNode((ITreeNode)node));
                }
                return null;
            }

            protected boolean shouldVisitSubtreeOfFullMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }

            protected boolean shouldVisitSubtreeOfInternalMatchedNode(IConfigMNode node) {
                return node.getSchemaTemplateId() == -1 && super.shouldVisitSubtreeOfFullMatchedNode((IMNode)node);
            }
        };){
            collector.traverse();
        }
        return result;
    }

    public void setTemplate(int templateId, PartialPath templateSetPath) throws MetadataException {
        this.getNodeWithAutoCreate(templateSetPath).setSchemaTemplateId(templateId);
    }

    public void preUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).preUnsetSchemaTemplate();
    }

    public void rollbackUnsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).rollbackUnsetSchemaTemplate();
    }

    public void unsetTemplate(int templateId, PartialPath path) throws MetadataException {
        this.getNodeSetTemplate(templateId, path).unsetSchemaTemplate();
    }

    private IConfigMNode getNodeSetTemplate(int templateId, PartialPath path) throws MetadataException {
        String[] nodeNames = path.getNodes();
        IConfigMNode cur = this.root;
        for (int i = 1; i < nodeNames.length; ++i) {
            if ((cur = (IConfigMNode)cur.getChild(nodeNames[i])) != null) continue;
            throw new PathNotExistException(path.getFullPath());
        }
        if (cur.getSchemaTemplateId() != templateId) {
            throw new MetadataException(String.format("Template %s is not set on path %s", templateId, path));
        }
        return cur;
    }

    public void serialize(OutputStream outputStream) throws IOException {
        this.serializeConfigBasicMNode(this.root, outputStream);
    }

    private void serializeConfigBasicMNode(IConfigMNode node, OutputStream outputStream) throws IOException {
        this.serializeChildren(node, outputStream);
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getSchemaTemplateId(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
    }

    private void serializeChildren(IConfigMNode node, OutputStream outputStream) throws IOException {
        for (IConfigMNode child : node.getChildren().values()) {
            if (child.isDatabase()) {
                this.serializeDatabaseNode((IDatabaseMNode<IConfigMNode>)child.getAsDatabaseMNode(), outputStream);
                continue;
            }
            this.serializeConfigBasicMNode(child, outputStream);
        }
    }

    private void serializeDatabaseNode(IDatabaseMNode<IConfigMNode> storageGroupNode, OutputStream outputStream) throws IOException {
        this.serializeChildren((IConfigMNode)storageGroupNode.getAsMNode(), outputStream);
        ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
        ReadWriteIOUtils.write((String)storageGroupNode.getName(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)((IConfigMNode)storageGroupNode.getAsMNode()).getSchemaTemplateId(), (OutputStream)outputStream);
        ThriftConfigNodeSerDeUtils.serializeTDatabaseSchema((TDatabaseSchema)((IConfigMNode)storageGroupNode.getAsMNode()).getDatabaseSchema(), (OutputStream)outputStream);
    }

    public void deserialize(InputStream inputStream) throws IOException {
        IConfigMNode internalMNode;
        IConfigMNode databaseMNode;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        String name = null;
        int childNum = 0;
        Stack<Pair> stack = new Stack<Pair>();
        if (type == 1) {
            databaseMNode = this.deserializeDatabaseMNode(inputStream);
            name = databaseMNode.getName();
            stack.push(new Pair((Object)databaseMNode, (Object)true));
        } else {
            internalMNode = this.deserializeInternalMNode(inputStream);
            childNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
            name = internalMNode.getName();
            stack.push(new Pair((Object)internalMNode, (Object)false));
        }
        block4: while (!"root".equals(name)) {
            type = ReadWriteIOUtils.readByte((InputStream)inputStream);
            switch (type) {
                case 0: {
                    internalMNode = this.deserializeInternalMNode(inputStream);
                    boolean hasDB = false;
                    for (childNum = ReadWriteIOUtils.readInt((InputStream)inputStream); childNum > 0; --childNum) {
                        hasDB = (Boolean)((Pair)stack.peek()).right;
                        internalMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)internalMNode, (Object)hasDB));
                    name = internalMNode.getName();
                    continue block4;
                }
                case 1: {
                    databaseMNode = (IConfigMNode)this.deserializeDatabaseMNode(inputStream).getAsMNode();
                    childNum = 0;
                    while (!stack.isEmpty() && !((Boolean)((Pair)stack.peek()).right).booleanValue()) {
                        databaseMNode.addChild((IConfigMNode)((Pair)stack.pop()).left);
                    }
                    stack.push(new Pair((Object)databaseMNode, (Object)true));
                    name = databaseMNode.getName();
                    continue block4;
                }
            }
            this.logger.error("Unrecognized node type. Cannot deserialize MTreeAboveSG from given buffer");
            return;
        }
        this.root = (IConfigMNode)((Pair)stack.peek()).left;
    }

    private IConfigMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
        IConfigMNode basicMNode = (IConfigMNode)this.nodeFactory.createInternalMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        basicMNode.setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        return basicMNode;
    }

    private IConfigMNode deserializeDatabaseMNode(InputStream inputStream) throws IOException {
        IDatabaseMNode databaseMNode = this.nodeFactory.createDatabaseMNode(null, ReadWriteIOUtils.readString((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setSchemaTemplateId(ReadWriteIOUtils.readInt((InputStream)inputStream));
        ((IConfigMNode)databaseMNode.getAsMNode()).setDatabaseSchema(ThriftConfigNodeSerDeUtils.deserializeTDatabaseSchema((InputStream)inputStream));
        return (IConfigMNode)databaseMNode.getAsMNode();
    }
}

