/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.client.DataNodeRequestType;
import org.apache.iotdb.confignode.client.async.AsyncDataNodeClientPool;
import org.apache.iotdb.confignode.client.async.handlers.AsyncClientHandler;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.GreedyLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.ILeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.MinCostFlowLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.IPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.LeaderPriorityBalancer;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.mpp.rpc.thrift.TRegionLeaderChangeReq;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteBalancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteBalancer.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getSchemaRegionConsensusProtocolClass();
    private static final String DATA_REGION_CONSENSUS_PROTOCOL_CLASS = CONF.getDataRegionConsensusProtocolClass();
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(DATA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private static final boolean IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION = CONF.isEnableAutoLeaderBalanceForRatisConsensus() && "org.apache.iotdb.consensus.ratis.RatisConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS) || CONF.isEnableAutoLeaderBalanceForIoTConsensus() && "org.apache.iotdb.consensus.iot.IoTConsensus".equals(SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS);
    private final IManager configManager;
    private final ILeaderBalancer leaderBalancer;
    private final IPriorityBalancer priorityRouter;

    public RouteBalancer(IManager configManager) {
        this.configManager = configManager;
        switch (CONF.getLeaderDistributionPolicy()) {
            case "GREEDY": {
                this.leaderBalancer = new GreedyLeaderBalancer();
                break;
            }
            default: {
                this.leaderBalancer = new MinCostFlowLeaderBalancer();
            }
        }
        switch (CONF.getRoutePriorityPolicy()) {
            case "GREEDY": {
                this.priorityRouter = new GreedyPriorityBalancer();
                break;
            }
            default: {
                this.priorityRouter = new LeaderPriorityBalancer();
            }
        }
    }

    public Map<TConsensusGroupId, Pair<Integer, Integer>> balanceRegionLeader() {
        ConcurrentHashMap<TConsensusGroupId, Pair<Integer, Integer>> differentRegionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Pair<Integer, Integer>>();
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_SCHEMA_REGION) {
            differentRegionLeaderMap.putAll(this.balanceRegionLeader(TConsensusGroupType.SchemaRegion));
        }
        if (IS_ENABLE_AUTO_LEADER_BALANCE_FOR_DATA_REGION) {
            differentRegionLeaderMap.putAll(this.balanceRegionLeader(TConsensusGroupType.DataRegion));
        }
        return differentRegionLeaderMap;
    }

    private Map<TConsensusGroupId, Pair<Integer, Integer>> balanceRegionLeader(TConsensusGroupType regionGroupType) {
        ConcurrentHashMap<TConsensusGroupId, Pair<Integer, Integer>> differentRegionLeaderMap = new ConcurrentHashMap<TConsensusGroupId, Pair<Integer, Integer>>();
        Map<TConsensusGroupId, Integer> currentLeaderMap = this.getLoadManager().getRegionLeaderMap();
        Map<TConsensusGroupId, Integer> optimalLeaderMap = this.leaderBalancer.generateOptimalLeaderDistribution(this.getPartitionManager().getAllReplicaSetsMap(regionGroupType), currentLeaderMap, this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Unknown, NodeStatus.ReadOnly, NodeStatus.Removing).stream().map(TDataNodeConfiguration::getLocation).map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
        AtomicInteger requestId = new AtomicInteger(0);
        AsyncClientHandler clientHandler = new AsyncClientHandler(DataNodeRequestType.CHANGE_REGION_LEADER);
        optimalLeaderMap.forEach((regionGroupId, newLeaderId) -> {
            if (newLeaderId != -1 && !newLeaderId.equals(currentLeaderMap.get(regionGroupId))) {
                String consensusProtocolClass;
                switch (regionGroupId.getType()) {
                    case SchemaRegion: {
                        consensusProtocolClass = SCHEMA_REGION_CONSENSUS_PROTOCOL_CLASS;
                        break;
                    }
                    default: {
                        consensusProtocolClass = DATA_REGION_CONSENSUS_PROTOCOL_CLASS;
                    }
                }
                LOGGER.info("[LeaderBalancer] Try to change the leader of Region: {} to DataNode: {} ", regionGroupId, newLeaderId);
                this.changeRegionLeader(consensusProtocolClass, requestId, clientHandler, (TConsensusGroupId)regionGroupId, this.getNodeManager().getRegisteredDataNode((int)newLeaderId).getLocation());
                differentRegionLeaderMap.put((TConsensusGroupId)regionGroupId, (Pair<Integer, Integer>)new Pair((Object)((Integer)currentLeaderMap.get(regionGroupId)), newLeaderId));
            }
        });
        if (requestId.get() > 0) {
            AsyncDataNodeClientPool.getInstance().sendAsyncRequestToDataNode(clientHandler);
        }
        return differentRegionLeaderMap;
    }

    private void changeRegionLeader(String consensusProtocolClass, AtomicInteger requestId, AsyncClientHandler<TRegionLeaderChangeReq, TSStatus> clientHandler, TConsensusGroupId regionGroupId, TDataNodeLocation newLeader) {
        switch (consensusProtocolClass) {
            case "org.apache.iotdb.consensus.iot.IoTConsensus": {
                this.getLoadManager().forceUpdateRegionLeader(regionGroupId, newLeader.getDataNodeId());
                break;
            }
            default: {
                TRegionLeaderChangeReq regionLeaderChangeReq = new TRegionLeaderChangeReq(regionGroupId, newLeader);
                int requestIndex = requestId.getAndIncrement();
                clientHandler.putRequest(requestIndex, regionLeaderChangeReq);
                clientHandler.putDataNodeLocation(requestIndex, newLeader);
            }
        }
    }

    public Map<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> balanceRegionPriority() {
        Map<TConsensusGroupId, TRegionReplicaSet> currentPriorityMap = this.getLoadManager().getRegionPriorityMap();
        Map<TConsensusGroupId, Integer> regionLeaderMap = this.getLoadManager().getRegionLeaderMap();
        Map<Integer, Long> dataNodeLoadScoreMap = this.getLoadManager().getAllDataNodeLoadScores();
        Map<TConsensusGroupId, TRegionReplicaSet> optimalRegionPriorityMap = this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.SchemaRegion), regionLeaderMap, dataNodeLoadScoreMap);
        optimalRegionPriorityMap.putAll(this.priorityRouter.generateOptimalRoutePriority(this.getPartitionManager().getAllReplicaSets(TConsensusGroupType.DataRegion), regionLeaderMap, dataNodeLoadScoreMap));
        ConcurrentHashMap<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>> differentRegionPriorityMap = new ConcurrentHashMap<TConsensusGroupId, Pair<TRegionReplicaSet, TRegionReplicaSet>>();
        for (Map.Entry<TConsensusGroupId, TRegionReplicaSet> regionPriorityEntry : optimalRegionPriorityMap.entrySet()) {
            TConsensusGroupId regionGroupId = regionPriorityEntry.getKey();
            TRegionReplicaSet optimalRegionPriority = regionPriorityEntry.getValue();
            if (optimalRegionPriority.equals(currentPriorityMap.get(regionGroupId))) continue;
            differentRegionPriorityMap.put(regionGroupId, (Pair<TRegionReplicaSet, TRegionReplicaSet>)new Pair((Object)currentPriorityMap.get(regionGroupId), (Object)optimalRegionPriority));
            this.getLoadManager().forceUpdateRegionPriority(regionGroupId, optimalRegionPriority);
        }
        return differentRegionPriorityMap;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }
}

