/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertiesUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemPropertiesUtils.class);
    private static final File systemPropertiesFile = new File(ConfigNodeDescriptor.getInstance().getConf().getSystemDir() + File.separator + "confignode-system.properties");
    private static final ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final String CN_INTERNAL_ADDRESS = "cn_internal_address";
    private static final String CN_INTERNAL_PORT = "cn_internal_port";
    private static final String CN_CONSENSUS_PORT = "cn_consensus_port";
    private static final String CN_CONSENSUS_PROTOCOL = "config_node_consensus_protocol_class";
    private static final String DATA_CONSENSUS_PROTOCOL = "data_region_consensus_protocol_class";
    private static final String SCHEMA_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol_class";
    private static final String SERIES_PARTITION_SLOT_NUM = "series_partition_slot_num";
    private static final String SERIES_PARTITION_EXECUTOR_CLASS = "series_partition_executor_class";
    private static final String TIME_PARTITION_INTERVAL = "time_partition_interval";

    private SystemPropertiesUtils() {
        throw new IllegalStateException("Utility class: SystemPropertiesUtils.");
    }

    public static boolean isRestarted() {
        return systemPropertiesFile.exists();
    }

    public static void checkSystemProperties() throws IOException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        boolean needReWrite = false;
        String format = "[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}";
        String clusterName = systemProperties.getProperty("cluster_name", null);
        if (clusterName == null) {
            needReWrite = true;
        } else if (!clusterName.equals(conf.getClusterName())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{"cluster_name", conf.getClusterName(), clusterName});
            conf.setClusterName(clusterName);
        }
        String internalAddress = systemProperties.getProperty(CN_INTERNAL_ADDRESS, null);
        if (internalAddress == null) {
            needReWrite = true;
        } else if (!internalAddress.equals(conf.getInternalAddress())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{CN_INTERNAL_ADDRESS, conf.getInternalAddress(), internalAddress});
            conf.setInternalAddress(internalAddress);
        }
        if (systemProperties.getProperty(CN_INTERNAL_PORT, null) == null) {
            needReWrite = true;
        } else {
            int internalPort = Integer.parseInt(systemProperties.getProperty(CN_INTERNAL_PORT));
            if (internalPort != conf.getInternalPort()) {
                LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{CN_INTERNAL_PORT, conf.getInternalPort(), internalPort});
                conf.setInternalPort(internalPort);
            }
        }
        if (systemProperties.getProperty(CN_CONSENSUS_PORT, null) == null) {
            needReWrite = true;
        } else {
            int consensusPort = Integer.parseInt(systemProperties.getProperty(CN_CONSENSUS_PORT));
            if (consensusPort != conf.getConsensusPort()) {
                LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{CN_CONSENSUS_PORT, conf.getConsensusPort(), consensusPort});
                conf.setConsensusPort(consensusPort);
            }
        }
        String configNodeConsensusProtocolClass = systemProperties.getProperty(CN_CONSENSUS_PROTOCOL, null);
        if (configNodeConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!configNodeConsensusProtocolClass.equals(conf.getConfigNodeConsensusProtocolClass())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{CN_CONSENSUS_PROTOCOL, conf.getConfigNodeConsensusProtocolClass(), configNodeConsensusProtocolClass});
            conf.setConfigNodeConsensusProtocolClass(configNodeConsensusProtocolClass);
        }
        String dataRegionConsensusProtocolClass = systemProperties.getProperty(DATA_CONSENSUS_PROTOCOL, null);
        if (dataRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!dataRegionConsensusProtocolClass.equals(conf.getDataRegionConsensusProtocolClass())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{DATA_CONSENSUS_PROTOCOL, conf.getDataRegionConsensusProtocolClass(), dataRegionConsensusProtocolClass});
            conf.setDataRegionConsensusProtocolClass(dataRegionConsensusProtocolClass);
        }
        String schemaRegionConsensusProtocolClass = systemProperties.getProperty(SCHEMA_CONSENSUS_PROTOCOL, null);
        if (schemaRegionConsensusProtocolClass == null) {
            needReWrite = true;
        } else if (!schemaRegionConsensusProtocolClass.equals(conf.getSchemaRegionConsensusProtocolClass())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{SCHEMA_CONSENSUS_PROTOCOL, conf.getSchemaRegionConsensusProtocolClass(), schemaRegionConsensusProtocolClass});
            conf.setSchemaRegionConsensusProtocolClass(schemaRegionConsensusProtocolClass);
        }
        if (systemProperties.getProperty(SERIES_PARTITION_SLOT_NUM, null) == null) {
            needReWrite = true;
        } else {
            int seriesPartitionSlotNum = Integer.parseInt(systemProperties.getProperty(SERIES_PARTITION_SLOT_NUM));
            if (seriesPartitionSlotNum != conf.getSeriesSlotNum()) {
                LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{"series_slot_num", conf.getSeriesSlotNum(), seriesPartitionSlotNum});
                conf.setSeriesSlotNum(seriesPartitionSlotNum);
            }
        }
        String seriesPartitionSlotExecutorClass = systemProperties.getProperty(SERIES_PARTITION_EXECUTOR_CLASS, null);
        if (seriesPartitionSlotExecutorClass == null) {
            needReWrite = true;
        } else if (!Objects.equals(seriesPartitionSlotExecutorClass, conf.getSeriesPartitionExecutorClass())) {
            LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{SERIES_PARTITION_EXECUTOR_CLASS, conf.getSeriesPartitionExecutorClass(), seriesPartitionSlotExecutorClass});
            conf.setSeriesPartitionExecutorClass(seriesPartitionSlotExecutorClass);
        }
        if (systemProperties.getProperty(TIME_PARTITION_INTERVAL, null) == null) {
            needReWrite = true;
        } else {
            long timePartitionInterval = Long.parseLong(systemProperties.getProperty(TIME_PARTITION_INTERVAL));
            if (timePartitionInterval != COMMON_CONFIG.getTimePartitionInterval()) {
                LOGGER.warn("[SystemProperties] The parameter \"{}\" can't be modified after first startup. Your configuration: {} will be forced update to: {}", new Object[]{TIME_PARTITION_INTERVAL, COMMON_CONFIG.getTimePartitionInterval(), timePartitionInterval});
                COMMON_CONFIG.setTimePartitionInterval(timePartitionInterval);
            }
        }
        if (needReWrite) {
            SystemPropertiesUtils.storeSystemParameters();
        }
    }

    public static List<TConfigNodeLocation> loadConfigNodeList() throws IOException, BadNodeUrlException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        String addresses = systemProperties.getProperty("config_node_list", null);
        if (addresses != null && !addresses.isEmpty()) {
            return NodeUrlUtils.parseTConfigNodeUrls((String)addresses);
        }
        return new ArrayList<TConfigNodeLocation>();
    }

    public static void storeSystemParameters() throws IOException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        systemProperties.setProperty("iotdb_version", IoTDBConstant.VERSION);
        systemProperties.setProperty("commit_id", IoTDBConstant.BUILD_INFO);
        systemProperties.setProperty("cluster_name", conf.getClusterName());
        LOGGER.info("[SystemProperties] store cluster_name: {}", (Object)conf.getClusterName());
        systemProperties.setProperty("config_node_id", String.valueOf(conf.getConfigNodeId()));
        LOGGER.info("[SystemProperties] store config_node_id: {}", (Object)conf.getConfigNodeId());
        systemProperties.setProperty("is_seed_config_node", String.valueOf(ConfigNodeDescriptor.getInstance().isSeedConfigNode()));
        LOGGER.info("[SystemProperties] store is_seed_config_node: {}", (Object)ConfigNodeDescriptor.getInstance().isSeedConfigNode());
        systemProperties.setProperty(CN_INTERNAL_ADDRESS, String.valueOf(conf.getInternalAddress()));
        systemProperties.setProperty(CN_INTERNAL_PORT, String.valueOf(conf.getInternalPort()));
        systemProperties.setProperty(CN_CONSENSUS_PORT, String.valueOf(conf.getConsensusPort()));
        systemProperties.setProperty(CN_CONSENSUS_PROTOCOL, conf.getConfigNodeConsensusProtocolClass());
        systemProperties.setProperty(DATA_CONSENSUS_PROTOCOL, conf.getDataRegionConsensusProtocolClass());
        systemProperties.setProperty(SCHEMA_CONSENSUS_PROTOCOL, conf.getSchemaRegionConsensusProtocolClass());
        systemProperties.setProperty(SERIES_PARTITION_SLOT_NUM, String.valueOf(conf.getSeriesSlotNum()));
        systemProperties.setProperty(SERIES_PARTITION_EXECUTOR_CLASS, conf.getSeriesPartitionExecutorClass());
        systemProperties.setProperty(TIME_PARTITION_INTERVAL, String.valueOf(COMMON_CONFIG.getTimePartitionInterval()));
        systemProperties.setProperty("timestamp_precision", COMMON_CONFIG.getTimestampPrecision());
        systemProperties.setProperty("schema_engine_mode", COMMON_CONFIG.getSchemaEngineMode());
        systemProperties.setProperty("tag_attribute_total_size", String.valueOf(COMMON_CONFIG.getTagAttributeTotalSize()));
        SystemPropertiesUtils.storeSystemProperties(systemProperties);
    }

    public static void storeConfigNodeList(List<TConfigNodeLocation> configNodes) throws IOException {
        if (!systemPropertiesFile.exists()) {
            return;
        }
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        systemProperties.setProperty("config_node_list", NodeUrlUtils.convertTConfigNodeUrls(configNodes));
        SystemPropertiesUtils.storeSystemProperties(systemProperties);
    }

    public static String loadClusterNameWhenRestarted() throws IOException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        String clusterName = systemProperties.getProperty("cluster_name", null);
        if (clusterName == null) {
            LOGGER.warn("Lack cluster_name field in data/confignode/system/confignode-system.properties, set it as defaultCluster");
            systemProperties.setProperty("cluster_name", "defaultCluster");
            return systemProperties.getProperty("cluster_name", null);
        }
        return clusterName;
    }

    public static int loadConfigNodeIdWhenRestarted() throws IOException {
        Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
        try {
            return Integer.parseInt(systemProperties.getProperty("config_node_id", null));
        }
        catch (NumberFormatException e) {
            throw new IOException("The parameter config_node_id doesn't exist in data/confignode/system/confignode-system.properties. Please delete data dir data/confignode and restart again.");
        }
    }

    public static boolean isSeedConfigNode() {
        try {
            Properties systemProperties = SystemPropertiesUtils.getSystemProperties();
            boolean isSeedConfigNode = Boolean.parseBoolean(systemProperties.getProperty("is_seed_config_node", null));
            if (isSeedConfigNode) {
                return true;
            }
            return ConfigNodeDescriptor.getInstance().isSeedConfigNode();
        }
        catch (IOException ignore) {
            return false;
        }
    }

    private static synchronized Properties getSystemProperties() throws IOException {
        if (!systemPropertiesFile.exists()) {
            if (systemPropertiesFile.createNewFile()) {
                LOGGER.info("System properties file {} for ConfigNode is created.", (Object)systemPropertiesFile.getAbsolutePath());
            } else {
                LOGGER.error("Can't create the system properties file {} for ConfigNode. IoTDB-ConfigNode is shutdown.", (Object)systemPropertiesFile.getAbsolutePath());
                throw new IOException("Can't create system properties file");
            }
        }
        Properties systemProperties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(systemPropertiesFile);){
            systemProperties.load(inputStream);
        }
        return systemProperties;
    }

    private static synchronized void storeSystemProperties(Properties systemProperties) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(systemPropertiesFile);){
            systemProperties.store(fileOutputStream, " THIS FILE IS AUTOMATICALLY GENERATED. PLEASE DO NOT MODIFY THIS FILE !!!");
        }
    }
}

