/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.windowing.handler;

import org.apache.iotdb.db.utils.windowing.api.Evaluator;
import org.apache.iotdb.db.utils.windowing.configuration.Configuration;
import org.apache.iotdb.db.utils.windowing.exception.WindowingException;
import org.apache.iotdb.db.utils.windowing.runtime.WindowEvaluationTaskPoolManager;
import org.apache.iotdb.db.utils.windowing.window.EvictableBatchList;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class SlidingWindowEvaluationHandler {
    protected static final WindowEvaluationTaskPoolManager TASK_POOL_MANAGER = WindowEvaluationTaskPoolManager.getInstance();
    protected final Configuration configuration;
    protected final Evaluator evaluator;
    protected final EvictableBatchList data;
    private long maxTime;

    protected SlidingWindowEvaluationHandler(Configuration configuration, Evaluator evaluator) throws WindowingException {
        this.configuration = configuration;
        this.evaluator = evaluator;
        configuration.check();
        this.data = new EvictableBatchList(configuration.getDataType());
        this.maxTime = Long.MIN_VALUE;
    }

    protected abstract void createEvaluationTaskIfNecessary(long var1);

    public final void collect(long timestamp, int value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putInt(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, long value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putLong(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, float value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putFloat(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, double value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putDouble(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, boolean value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putBoolean(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, String value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putBinary(timestamp, Binary.valueOf((String)value));
        this.createEvaluationTaskIfNecessary(timestamp);
    }

    public final void collect(long timestamp, Binary value) {
        if (timestamp <= this.maxTime) {
            return;
        }
        this.maxTime = timestamp;
        this.data.putBinary(timestamp, value);
        this.createEvaluationTaskIfNecessary(timestamp);
    }
}

