/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.PriorityQueue;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.SeriesCompactionExecutor;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PageElement;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.element.PointElement;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;

public class PointPriorityReader {
    private long lastTime;
    private final PriorityQueue<PointElement> pointQueue;
    private final SeriesCompactionExecutor.RemovePage removePage;
    private TimeValuePair currentPoint;
    private long nextPointInOtherPage = Long.MAX_VALUE;
    private PointElement currentPointElement;
    private final boolean isAligned;

    public PointPriorityReader(SeriesCompactionExecutor.RemovePage removePage, boolean isAligned) {
        this.removePage = removePage;
        this.pointQueue = new PriorityQueue((o1, o2) -> {
            int timeCompare = Long.compare(o1.timestamp, o2.timestamp);
            return timeCompare != 0 ? timeCompare : Long.compare(o2.priority, o1.priority);
        });
        this.isAligned = isAligned;
    }

    public TimeValuePair currentPoint() {
        if (this.currentPointElement == null) {
            this.currentPoint = this.pointQueue.peek().timeValuePair;
            this.lastTime = this.currentPoint.getTimestamp();
            if (this.isAligned) {
                this.fillAlignedNullValue();
            }
        }
        return this.currentPoint;
    }

    private void fillAlignedNullValue() {
        ArrayList<PointElement> pointElementsWithSameTimestamp = new ArrayList<PointElement>();
        pointElementsWithSameTimestamp.add(this.pointQueue.poll());
        TsPrimitiveType[] currentValues = this.currentPoint.getValue().getVector();
        int nullValueNum = currentValues.length;
        while (!this.pointQueue.isEmpty() && this.pointQueue.peek().timestamp <= this.lastTime) {
            PointElement pointElement = this.pointQueue.poll();
            pointElementsWithSameTimestamp.add(pointElement);
            TsPrimitiveType[] values = pointElement.timeValuePair.getValue().getVector();
            for (int i = 0; i < values.length; ++i) {
                if (currentValues[i] == null) {
                    if (values[i] == null) continue;
                    currentValues[i] = values[i];
                    --nullValueNum;
                    continue;
                }
                --nullValueNum;
            }
            if (nullValueNum != 0) continue;
        }
        this.pointQueue.addAll(pointElementsWithSameTimestamp);
    }

    public void next() throws IllegalPathException, IOException, WriteProcessException {
        if (this.currentPointElement != null) {
            if (this.currentPointElement.hasNext()) {
                this.currentPoint = this.currentPointElement.next();
                if (this.currentPoint.getTimestamp() >= this.nextPointInOtherPage) {
                    this.pointQueue.add(this.currentPointElement);
                    this.currentPointElement = null;
                }
            } else {
                PageElement pageElement = this.currentPointElement.pageElement;
                this.currentPointElement = null;
                this.removePage.call(pageElement);
            }
        } else {
            while (!this.pointQueue.isEmpty() && this.pointQueue.peek().timestamp == this.lastTime) {
                PointElement pointElement = this.pointQueue.poll();
                if (pointElement.hasNext()) {
                    pointElement.next();
                    long l = this.nextPointInOtherPage = !this.pointQueue.isEmpty() ? this.pointQueue.peek().timestamp : Long.MAX_VALUE;
                    if (pointElement.timestamp < this.nextPointInOtherPage) {
                        this.currentPointElement = pointElement;
                        this.currentPoint = this.currentPointElement.timeValuePair;
                        continue;
                    }
                    this.pointQueue.add(pointElement);
                    continue;
                }
                this.removePage.call(pointElement.pageElement);
            }
        }
    }

    public boolean hasNext() {
        return this.currentPointElement != null || !this.pointQueue.isEmpty();
    }

    public boolean addNewPageIfPageNotEmpty(PageElement pageElement) throws IOException, IllegalPathException, WriteProcessException {
        boolean pageIsNotEmpty;
        if (this.currentPointElement != null) {
            this.nextPointInOtherPage = Math.min(this.nextPointInOtherPage, pageElement.startTime);
            if (this.currentPoint.getTimestamp() >= this.nextPointInOtherPage) {
                this.pointQueue.add(this.currentPointElement);
                this.currentPointElement = null;
            }
        }
        PointElement pointElement = new PointElement(pageElement);
        boolean bl = pageIsNotEmpty = pointElement.timeValuePair != null;
        if (pageIsNotEmpty) {
            this.pointQueue.add(pointElement);
        } else {
            this.removePage.call(pageElement);
        }
        return pageIsNotEmpty;
    }
}

