/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionExceptionHandler;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionFileCountExceededException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionMemoryNotEnoughException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionValidationFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICrossCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.validator.CompactionValidator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceList;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSpaceCompactionTask
extends AbstractCompactionTask {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"COMPACTION");
    protected List<TsFileResource> selectedSequenceFiles;
    protected List<TsFileResource> selectedUnsequenceFiles;
    protected TsFileResourceList seqTsFileResourceList;
    protected TsFileResourceList unseqTsFileResourceList;
    private File logFile;
    protected List<TsFileResource> targetTsfileResourceList;
    protected List<TsFileResource> holdReadLockList = new ArrayList<TsFileResource>();
    protected List<TsFileResource> holdWriteLockList = new ArrayList<TsFileResource>();
    protected double selectedSeqFileSize = 0.0;
    protected double selectedUnseqFileSize = 0.0;

    public CrossSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedSequenceFiles, List<TsFileResource> selectedUnsequenceFiles, ICrossCompactionPerformer performer, AtomicInteger currentTaskNum, long memoryCost, long serialId) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, currentTaskNum, serialId);
        this.selectedSequenceFiles = selectedSequenceFiles;
        this.selectedUnsequenceFiles = selectedUnsequenceFiles;
        this.seqTsFileResourceList = tsFileManager.getOrCreateSequenceListByTimePartition(timePartition);
        this.unseqTsFileResourceList = tsFileManager.getOrCreateUnsequenceListByTimePartition(timePartition);
        this.performer = performer;
        this.hashCode = this.toString().hashCode();
        this.memoryCost = memoryCost;
        this.crossTask = true;
        this.innerSeqTask = false;
        this.createSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doCompaction() {
        boolean isSuccess = true;
        try {
            if (!this.tsFileManager.isAllowCompaction()) {
                boolean bl = true;
                return bl;
            }
            long startTime = System.currentTimeMillis();
            this.targetTsfileResourceList = TsFileNameGenerator.getCrossCompactionTargetFileResources(this.selectedSequenceFiles);
            if (this.targetTsfileResourceList.isEmpty() || this.selectedSequenceFiles.isEmpty() || this.selectedUnsequenceFiles.isEmpty()) {
                LOGGER.info("{}-{} [Compaction] Cross space compaction file list is empty, end it", (Object)this.storageGroupName, (Object)this.dataRegionId);
                boolean bl = true;
                return bl;
            }
            for (TsFileResource tsFileResource : this.selectedSequenceFiles) {
                this.selectedSeqFileSize += (double)tsFileResource.getTsFileSize();
            }
            for (TsFileResource tsFileResource : this.selectedUnsequenceFiles) {
                this.selectedUnseqFileSize += (double)tsFileResource.getTsFileSize();
            }
            LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task starts with {} seq files and {} unsequence files. Sequence files : {}, unsequence files : {} . Sequence files size is {} MB, unsequence file size is {} MB, total size is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedSequenceFiles.size(), this.selectedUnsequenceFiles.size(), this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.selectedSeqFileSize / 1024.0 / 1024.0, this.selectedUnseqFileSize / 1024.0 / 1024.0, (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0});
            this.logFile = new File(this.selectedSequenceFiles.get(0).getTsFile().getParent() + File.separator + this.targetTsfileResourceList.get(0).getTsFile().getName() + ".cross-compaction.log");
            try (CompactionLogger compactionLogger = new CompactionLogger(this.logFile);){
                compactionLogger.logFiles(this.selectedSequenceFiles, "source");
                compactionLogger.logFiles(this.selectedUnsequenceFiles, "source");
                compactionLogger.logFiles(this.targetTsfileResourceList, "target");
                this.performer.setSourceFiles(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                this.performer.setTargetFiles(this.targetTsfileResourceList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                CompactionUtils.updateProgressIndex(this.targetTsfileResourceList, this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                CompactionUtils.moveTargetFile(this.targetTsfileResourceList, false, this.storageGroupName + "-" + this.dataRegionId);
                CompactionUtils.combineModsInCrossCompaction(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList);
                this.tsFileManager.replace(this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList, this.timePartition, true);
                for (TsFileResource tsFileResource : this.targetTsfileResourceList) {
                    if (!tsFileResource.isDeleted()) continue;
                    compactionLogger.logFile(tsFileResource, "empty");
                }
                CompactionValidator compactionValidator = CompactionValidator.getInstance();
                if (!compactionValidator.validateCompaction(this.tsFileManager, this.targetTsfileResourceList, this.storageGroupName, this.timePartition, false)) {
                    LOGGER.error("Failed to pass compaction validation, source sequence files is: {}, unsequence files is {}, target files is {}", new Object[]{this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.targetTsfileResourceList});
                    throw new CompactionValidationFailedException("Failed to pass compaction validation");
                }
                this.releaseReadAndLockWrite(this.selectedSequenceFiles);
                this.releaseReadAndLockWrite(this.selectedUnsequenceFiles);
                for (TsFileResource sequenceResource : this.selectedSequenceFiles) {
                    if (!sequenceResource.getModFile().exists()) continue;
                    FileMetrics.getInstance().decreaseModFileNum(1);
                    FileMetrics.getInstance().decreaseModFileSize(sequenceResource.getModFile().getSize());
                }
                for (TsFileResource unsequenceResource : this.selectedUnsequenceFiles) {
                    if (!unsequenceResource.getModFile().exists()) continue;
                    FileMetrics.getInstance().decreaseModFileNum(1);
                    FileMetrics.getInstance().decreaseModFileSize(unsequenceResource.getModFile().getSize());
                }
                long[] lArray = this.deleteOldFiles(this.selectedSequenceFiles);
                ArrayList<String> fileNames = new ArrayList<String>(this.selectedSequenceFiles.size());
                this.selectedSequenceFiles.forEach(x -> fileNames.add(x.getTsFile().getName()));
                FileMetrics.getInstance().deleteFile(lArray, true, fileNames);
                fileNames.clear();
                this.selectedUnsequenceFiles.forEach(x -> fileNames.add(x.getTsFile().getName()));
                long[] unsequenceFileSize = this.deleteOldFiles(this.selectedUnsequenceFiles);
                FileMetrics.getInstance().deleteFile(unsequenceFileSize, false, fileNames);
                CompactionUtils.deleteCompactionModsFile(this.selectedSequenceFiles, this.selectedUnsequenceFiles);
                for (TsFileResource targetResource : this.targetTsfileResourceList) {
                    if (!targetResource.isDeleted()) {
                        FileMetrics.getInstance().addFile(targetResource.getTsFileSize(), true, targetResource.getTsFile().getName());
                        targetResource.setStatus(TsFileResourceStatus.NORMAL);
                        continue;
                    }
                    targetResource.remove();
                }
                CompactionMetrics.getInstance().recordSummaryInfo(this.summary);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] CrossSpaceCompaction task finishes successfully, time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, String.format("%.2f", costTime), String.format("%.2f", (this.selectedSeqFileSize + this.selectedUnseqFileSize) / 1024.0 / 1024.0 / costTime), this.summary});
            }
            if (this.logFile.exists()) {
                FileUtils.delete((File)this.logFile);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            if (!(e instanceof InterruptedException)) {
                LOGGER.error("{}-{} [Compaction] Meet errors in cross space compaction.", new Object[]{this.storageGroupName, this.dataRegionId, e});
            } else {
                LOGGER.warn("{}-{} [Compaction] Compaction interrupted", (Object)this.storageGroupName, (Object)this.dataRegionId);
                Thread.interrupted();
            }
            CompactionExceptionHandler.handleException(this.storageGroupName + "-" + this.dataRegionId, this.logFile, this.targetTsfileResourceList, this.selectedSequenceFiles, this.selectedUnsequenceFiles, this.tsFileManager, this.timePartition, false, true);
        }
        finally {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            SystemInfo.getInstance().decreaseCompactionFileNumCost(this.selectedSequenceFiles.size() + this.selectedUnsequenceFiles.size());
            this.releaseAllLocksAndResetStatus();
        }
        return isSuccess;
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        CrossSpaceCompactionTask otherCrossCompactionTask = (CrossSpaceCompactionTask)otherTask;
        return this.selectedSequenceFiles.equals(otherCrossCompactionTask.selectedSequenceFiles) && this.selectedUnsequenceFiles.equals(otherCrossCompactionTask.selectedUnsequenceFiles) && this.performer.getClass().isInstance(otherCrossCompactionTask.performer);
    }

    private void releaseAllLocksAndResetStatus() {
        this.resetCompactionCandidateStatusForAllSourceFiles();
        for (TsFileResource tsFileResource : this.holdReadLockList) {
            tsFileResource.readUnlock();
        }
        for (TsFileResource tsFileResource : this.holdWriteLockList) {
            tsFileResource.writeUnlock();
        }
        this.holdReadLockList.clear();
        this.holdWriteLockList.clear();
    }

    public List<TsFileResource> getSelectedSequenceFiles() {
        return this.selectedSequenceFiles;
    }

    @Override
    protected List<TsFileResource> getAllSourceTsFiles() {
        ArrayList<TsFileResource> allRelatedFiles = new ArrayList<TsFileResource>();
        allRelatedFiles.addAll(this.selectedSequenceFiles);
        allRelatedFiles.addAll(this.selectedUnsequenceFiles);
        return allRelatedFiles;
    }

    public List<TsFileResource> getSelectedUnsequenceFiles() {
        return this.selectedUnsequenceFiles;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task seq files are " + this.selectedSequenceFiles.toString() + " , unseq files are " + this.selectedUnsequenceFiles.toString();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CrossSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((CrossSpaceCompactionTask)other);
    }

    private long[] deleteOldFiles(List<TsFileResource> tsFileResourceList) {
        long[] size = new long[tsFileResourceList.size()];
        int length = tsFileResourceList.size();
        for (int i = 0; i < length; ++i) {
            TsFileResource tsFileResource = tsFileResourceList.get(i);
            size[i] = tsFileResource.getTsFileSize();
            tsFileResource.remove();
            LOGGER.info("[CrossSpaceCompaction] Delete TsFile :{}.", (Object)tsFileResource.getTsFile().getAbsolutePath());
        }
        return size;
    }

    private void releaseReadAndLockWrite(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            tsFileResource.readUnlock();
            this.holdReadLockList.remove(tsFileResource);
            tsFileResource.writeLock();
            this.holdWriteLockList.add(tsFileResource);
        }
    }

    @Override
    public boolean checkValidAndSetMerging() {
        boolean addReadLockSuccess;
        if (!this.tsFileManager.isAllowCompaction()) {
            this.resetCompactionCandidateStatusForAllSourceFiles();
            return false;
        }
        try {
            SystemInfo.getInstance().addCompactionMemoryCost(this.memoryCost, 60L);
            SystemInfo.getInstance().addCompactionFileNum(this.selectedSequenceFiles.size() + this.selectedUnsequenceFiles.size(), 60L);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                LOGGER.warn("Interrupted when allocating memory for compaction", (Throwable)e);
                Thread.currentThread().interrupt();
            } else if (e instanceof CompactionMemoryNotEnoughException) {
                LOGGER.info("No enough memory for current compaction task {}", (Object)this, (Object)e);
            } else if (e instanceof CompactionFileCountExceededException) {
                LOGGER.info("No enough file num for current compaction task {}", (Object)this, (Object)e);
                SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            }
            this.resetCompactionCandidateStatusForAllSourceFiles();
            return false;
        }
        boolean bl = addReadLockSuccess = this.addReadLock(this.selectedSequenceFiles) && this.addReadLock(this.selectedUnsequenceFiles);
        if (!addReadLockSuccess) {
            SystemInfo.getInstance().resetCompactionMemoryCost(this.memoryCost);
            SystemInfo.getInstance().decreaseCompactionFileNumCost(this.selectedSequenceFiles.size() + this.selectedUnsequenceFiles.size());
        }
        return addReadLockSuccess;
    }

    private boolean addReadLock(List<TsFileResource> tsFileResourceList) {
        try {
            for (TsFileResource tsFileResource : tsFileResourceList) {
                tsFileResource.readLock();
                this.holdReadLockList.add(tsFileResource);
                if (tsFileResource.setStatus(TsFileResourceStatus.COMPACTING)) continue;
                this.releaseAllLocksAndResetStatus();
                return false;
            }
        }
        catch (Exception e) {
            this.releaseAllLocksAndResetStatus();
            throw e;
        }
        return true;
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }
}

