/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.multi;

import org.apache.iotdb.db.queryengine.transformation.dag.adapter.ElasticSerializableRowRecordListBackedMultiColumnRow;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;

public class MappableUDFColumnTransformer
extends ColumnTransformer {
    private final ColumnTransformer[] inputColumnTransformers;
    private final UDTFExecutor executor;
    private final TSDataType[] inputDataTypes;

    public MappableUDFColumnTransformer(Type returnType, ColumnTransformer[] inputColumnTransformers, TSDataType[] inputDataTypes, UDTFExecutor executor) {
        super(returnType);
        this.inputColumnTransformers = inputColumnTransformers;
        this.executor = executor;
        this.inputDataTypes = inputDataTypes;
    }

    @Override
    public void evaluate() {
        for (ColumnTransformer inputColumnTransformer : this.inputColumnTransformers) {
            inputColumnTransformer.tryEvaluate();
        }
        int size = this.inputColumnTransformers.length;
        Column[] columns = new Column[size];
        int positionCount = this.inputColumnTransformers[0].getColumnCachePositionCount();
        for (int i = 0; i < size; ++i) {
            columns[i] = this.inputColumnTransformers[i].getColumn();
        }
        ColumnBuilder columnBuilder = this.returnType.createColumnBuilder(positionCount);
        for (int i = 0; i < positionCount; ++i) {
            Object[] values = new Object[size];
            for (int j = 0; j < size; ++j) {
                values[j] = columns[j].isNull(i) ? null : columns[j].getObject(i);
            }
            ElasticSerializableRowRecordListBackedMultiColumnRow row = new ElasticSerializableRowRecordListBackedMultiColumnRow(this.inputDataTypes);
            row.setRowRecord(values);
            this.executor.execute(row);
            Object res = this.executor.getCurrentValue();
            if (res != null) {
                this.returnType.writeObject(columnBuilder, res);
                continue;
            }
            columnBuilder.appendNull();
        }
        this.initializeColumnCache(columnBuilder.build());
    }

    @Override
    protected void checkType() {
    }

    public ColumnTransformer[] getInputColumnTransformers() {
        return this.inputColumnTransformers;
    }

    @Override
    public void close() {
        this.executor.beforeDestroy();
    }
}

