/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class InternalCreateTimeSeriesStatement
extends Statement {
    private final PartialPath devicePath;
    private final List<String> measurements;
    private final List<TSDataType> tsDataTypes;
    private final List<TSEncoding> encodings;
    private final List<CompressionType> compressors;
    private final boolean isAligned;

    public InternalCreateTimeSeriesStatement(PartialPath devicePath, List<String> measurements, List<TSDataType> tsDataTypes, List<TSEncoding> encodings, List<CompressionType> compressors, boolean isAligned) {
        this.setType(StatementType.INTERNAL_CREATE_TIMESERIES);
        this.devicePath = devicePath;
        this.measurements = measurements;
        this.tsDataTypes = tsDataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
        this.isAligned = isAligned;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public List<String> getMeasurements() {
        return this.measurements;
    }

    public List<TSDataType> getTsDataTypes() {
        return this.tsDataTypes;
    }

    public List<TSEncoding> getEncodings() {
        return this.encodings;
    }

    public List<CompressionType> getCompressors() {
        return this.compressors;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public List<PartialPath> getPaths() {
        return this.measurements.stream().map(arg_0 -> ((PartialPath)this.devicePath).concatNode(arg_0)).collect(Collectors.toList());
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitInternalCreateTimeseries(this, context);
    }
}

