/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.cartesian.CartesianProductVisitor;

public class ConcatExpressionWithSuffixPathsVisitor
extends CartesianProductVisitor<Context> {
    @Override
    public List<Expression> visitFunctionExpression(FunctionExpression functionExpression, Context context) {
        ArrayList extendedExpressions = new ArrayList();
        for (Expression suffixExpression : functionExpression.getExpressions()) {
            extendedExpressions.add((List)this.process(suffixExpression, context));
            if (!functionExpression.isBuiltInAggregationFunctionExpression()) continue;
            List<Expression> children = functionExpression.getExpressions();
            for (int i = 1; i < children.size(); ++i) {
                extendedExpressions.add(Collections.singletonList(children.get(i)));
            }
        }
        ArrayList<List<Expression>> childExpressionsList = new ArrayList<List<Expression>>();
        ExpressionUtils.cartesianProduct(extendedExpressions, childExpressionsList, 0, new ArrayList());
        return ExpressionUtils.reconstructFunctionExpressions(functionExpression, childExpressionsList);
    }

    @Override
    public List<Expression> visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, Context context) {
        PartialPath rawPath = timeSeriesOperand.getPath();
        ArrayList<PartialPath> actualPaths = new ArrayList<PartialPath>();
        if (rawPath.getFullPath().startsWith("root.")) {
            actualPaths.add(rawPath);
            context.getPatternTree().appendPathPattern(rawPath);
        } else {
            for (PartialPath prefixPath : context.getPrefixPaths()) {
                PartialPath concatPath = prefixPath.concatPath(rawPath);
                context.getPatternTree().appendPathPattern(concatPath);
                actualPaths.add(concatPath);
            }
        }
        return ExpressionUtils.reconstructTimeSeriesOperands(timeSeriesOperand, actualPaths);
    }

    @Override
    public List<Expression> visitTimeStampOperand(TimestampOperand timestampOperand, Context context) {
        return Collections.singletonList(timestampOperand);
    }

    @Override
    public List<Expression> visitConstantOperand(ConstantOperand constantOperand, Context context) {
        return Collections.singletonList(constantOperand);
    }

    public static class Context {
        private final List<PartialPath> prefixPaths;
        private final PathPatternTree patternTree;

        public Context(List<PartialPath> prefixPaths, PathPatternTree patternTree) {
            this.prefixPaths = prefixPaths;
            this.patternTree = patternTree;
        }

        public List<PartialPath> getPrefixPaths() {
            return this.prefixPaths;
        }

        public PathPatternTree getPatternTree() {
            return this.patternTree;
        }
    }
}

