/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.filter;

import java.io.IOException;
import javax.servlet.annotation.WebFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.filter.BasicSecurityContext;
import org.apache.iotdb.db.protocol.rest.filter.User;
import org.apache.iotdb.db.protocol.rest.filter.UserCache;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.rpc.TSStatusCode;
import org.glassfish.jersey.internal.util.Base64;

@WebFilter(value={"/*"})
@Provider
public class AuthorizationFilter
implements ContainerRequestFilter {
    private final IAuthorizer authorizer = AuthorizerManager.getInstance();
    private final UserCache userCache = UserCache.getInstance();
    IoTDBRestServiceConfig config = IoTDBRestServiceDescriptor.getInstance().getConfig();

    public void filter(ContainerRequestContext containerRequestContext) throws IOException {
        if ("OPTIONS".equals(containerRequestContext.getMethod()) || "ping".equals(containerRequestContext.getUriInfo().getPath()) || this.config.isEnableSwagger() && "swagger.json".equals(containerRequestContext.getUriInfo().getPath())) {
            return;
        }
        if (!this.config.isEnableSwagger() && "swagger.json".equals(containerRequestContext.getUriInfo().getPath())) {
            Response resp = Response.status((Response.Status)Response.Status.NOT_FOUND).type("application/json").entity((Object)"").build();
            containerRequestContext.abortWith(resp);
            return;
        }
        String authorizationHeader = containerRequestContext.getHeaderString("authorization");
        if (authorizationHeader == null) {
            Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.INIT_AUTH_ERROR.getStatusCode())).message(TSStatusCode.INIT_AUTH_ERROR.name())).build();
            containerRequestContext.abortWith(resp);
            return;
        }
        User user = this.userCache.getUser(authorizationHeader);
        if (user == null) {
            user = this.checkLogin(containerRequestContext, authorizationHeader);
            if (user == null) {
                return;
            }
            this.userCache.setUser(authorizationHeader, user);
        }
        BasicSecurityContext basicSecurityContext = new BasicSecurityContext(user, IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableHttps());
        containerRequestContext.setSecurityContext((SecurityContext)basicSecurityContext);
    }

    private User checkLogin(ContainerRequestContext containerRequestContext, String authorizationHeader) {
        String decoded = Base64.decodeAsString((String)authorizationHeader.replace("Basic ", ""));
        String[] split = decoded.split(":");
        if (split.length != 2) {
            Response resp = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.ILLEGAL_PARAMETER.getStatusCode())).message("Illegal format of authorization header.")).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        User user = new User();
        user.setUsername(split[0]);
        user.setPassword(split[1]);
        TSStatus tsStatus = ((AuthorizerManager)this.authorizer).checkUser(split[0], split[1]);
        if (tsStatus.code != 200) {
            Response resp = Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.WRONG_LOGIN_PASSWORD.getStatusCode())).message(TSStatusCode.WRONG_LOGIN_PASSWORD.name())).build();
            containerRequestContext.abortWith(resp);
            return null;
        }
        return user;
    }
}

