/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.stage;

import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.pipe.api.exception.PipeException;

public abstract class PipeTaskStage {
    private static final String MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_STARTED = "The PipeTaskStage has been started";
    private static final String MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_DROPPED = "The PipeTaskStage has been dropped";
    private static final String MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_STOPPED = "The PipeTaskStage has been externally stopped";
    private static final String MESSAGE_PIPE_TASK_STAGE_HAS_NOT_BEEN_CREATED = "The PipeTaskStage has not been created";
    protected PipeStatus status = null;
    protected boolean hasBeenExternallyStopped = false;

    public synchronized void create() {
        if (this.status != null) {
            if (this.status == PipeStatus.RUNNING) {
                throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_STARTED);
            }
            if (this.status == PipeStatus.DROPPED) {
                throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_DROPPED);
            }
            if (this.hasBeenExternallyStopped) {
                throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_STOPPED);
            }
            return;
        }
        this.createSubtask();
        this.status = PipeStatus.STOPPED;
    }

    protected abstract void createSubtask() throws PipeException;

    public synchronized void start() {
        if (this.status == null) {
            throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_NOT_BEEN_CREATED);
        }
        if (this.status == PipeStatus.RUNNING) {
            return;
        }
        if (this.status == PipeStatus.DROPPED) {
            throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_DROPPED);
        }
        this.startSubtask();
        this.status = PipeStatus.RUNNING;
    }

    protected abstract void startSubtask() throws PipeException;

    public synchronized void stop() {
        if (this.status == null) {
            throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_NOT_BEEN_CREATED);
        }
        if (this.status == PipeStatus.STOPPED) {
            return;
        }
        if (this.status == PipeStatus.DROPPED) {
            throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_BEEN_DROPPED);
        }
        this.stopSubtask();
        this.status = PipeStatus.STOPPED;
        this.hasBeenExternallyStopped = true;
    }

    protected abstract void stopSubtask() throws PipeException;

    public synchronized void drop() {
        if (this.status == null) {
            throw new PipeException(MESSAGE_PIPE_TASK_STAGE_HAS_NOT_BEEN_CREATED);
        }
        if (this.status == PipeStatus.DROPPED) {
            return;
        }
        this.dropSubtask();
        this.status = PipeStatus.DROPPED;
    }

    protected abstract void dropSubtask() throws PipeException;
}

