/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.thrift;

import org.apache.iotdb.db.pipe.connector.protocol.IoTDBConnectorRequestVersion;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiver;
import org.apache.iotdb.db.pipe.receiver.thrift.IoTDBThriftReceiverV1;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThriftReceiverAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBThriftReceiverAgent.class);
    private final ThreadLocal<IoTDBThriftReceiver> receiverThreadLocal = new ThreadLocal();

    public TPipeTransferResp receive(TPipeTransferReq req, IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher) {
        byte reqVersion = req.getVersion();
        if (reqVersion == IoTDBConnectorRequestVersion.VERSION_1.getVersion()) {
            return this.getReceiver(reqVersion).receive(req, partitionFetcher, schemaFetcher);
        }
        return new TPipeTransferResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.PIPE_VERSION_ERROR, (String)String.format("Unsupported pipe version %d", reqVersion)));
    }

    private IoTDBThriftReceiver getReceiver(byte reqVersion) {
        if (this.receiverThreadLocal.get() == null) {
            return this.setAndGetReceiver(reqVersion);
        }
        byte receiverThreadLocalVersion = this.receiverThreadLocal.get().getVersion().getVersion();
        if (receiverThreadLocalVersion != reqVersion) {
            LOGGER.warn("The receiver version {} is different from the sender version {}, the receiver will be reset to the sender version.", (Object)receiverThreadLocalVersion, (Object)reqVersion);
            this.receiverThreadLocal.get().handleExit();
            this.receiverThreadLocal.remove();
            return this.setAndGetReceiver(reqVersion);
        }
        return this.receiverThreadLocal.get();
    }

    private IoTDBThriftReceiver setAndGetReceiver(byte reqVersion) {
        if (reqVersion != IoTDBConnectorRequestVersion.VERSION_1.getVersion()) {
            throw new UnsupportedOperationException(String.format("Unsupported pipe version %d", reqVersion));
        }
        this.receiverThreadLocal.set(new IoTDBThriftReceiverV1());
        return this.receiverThreadLocal.get();
    }

    public void handleClientExit() {
        IoTDBThriftReceiver receiver = this.receiverThreadLocal.get();
        if (receiver != null) {
            receiver.handleExit();
            this.receiverThreadLocal.remove();
        }
    }
}

