/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.extractor.historical;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.config.plugin.env.PipeTaskExtractorRuntimeEnvironment;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.extractor.historical.PipeHistoricalDataRegionExtractor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeExtractorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHistoricalDataRegionTsFileExtractor
implements PipeHistoricalDataRegionExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHistoricalDataRegionTsFileExtractor.class);
    private static final Map<Integer, Long> DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP = new HashMap<Integer, Long>();
    private static final long PIPE_MIN_FLUSH_INTERVAL_IN_MS = 2000L;
    private PipeTaskMeta pipeTaskMeta;
    private ProgressIndex startIndex;
    private int dataRegionId;
    private String pattern;
    private long historicalDataExtractionStartTime;
    private long historicalDataExtractionEndTime;
    private long historicalDataExtractionTimeLowerBound;
    private Queue<PipeTsFileInsertionEvent> pendingQueue;

    public void validate(PipeParameterValidator validator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeExtractorRuntimeConfiguration configuration) {
        PipeTaskExtractorRuntimeEnvironment environment = (PipeTaskExtractorRuntimeEnvironment)configuration.getRuntimeEnvironment();
        this.pipeTaskMeta = environment.getPipeTaskMeta();
        this.startIndex = environment.getPipeTaskMeta().getProgressIndex();
        this.dataRegionId = environment.getRegionId();
        Map<Integer, Long> map = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
        synchronized (map) {
            DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.putIfAbsent(this.dataRegionId, 0L);
        }
        this.pattern = parameters.getStringOrDefault("extractor.pattern", "root");
        boolean isHistoricalExtractorEnabledByUser = parameters.getBooleanOrDefault("extractor.history.enable", true);
        this.historicalDataExtractionStartTime = isHistoricalExtractorEnabledByUser && parameters.hasAttribute("extractor.history.start-time") ? DateTimeUtils.convertDatetimeStrToLong(parameters.getString("extractor.history.start-time"), ZoneId.systemDefault()) : Long.MIN_VALUE;
        this.historicalDataExtractionEndTime = isHistoricalExtractorEnabledByUser && parameters.hasAttribute("extractor.history.end-time") ? DateTimeUtils.convertDatetimeStrToLong(parameters.getString("extractor.history.end-time"), ZoneId.systemDefault()) : Long.MAX_VALUE;
        long l = this.historicalDataExtractionTimeLowerBound = parameters.getBooleanOrDefault("extractor.history.enable", true) ? Long.MIN_VALUE : environment.getCreationTime();
        if (this.historicalDataExtractionTimeLowerBound != Long.MIN_VALUE) {
            Map<Integer, Long> map2 = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
            synchronized (map2) {
                long lastFlushedByPipeTime = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.get(this.dataRegionId);
                if (System.currentTimeMillis() - lastFlushedByPipeTime >= 2000L) {
                    this.flushDataRegionAllTsFiles();
                    DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.replace(this.dataRegionId, System.currentTimeMillis());
                }
            }
        }
    }

    private void flushDataRegionAllTsFiles() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            return;
        }
        dataRegion.writeLock("Pipe: create historical TsFile extractor");
        try {
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        DataRegion dataRegion = StorageEngine.getInstance().getDataRegion(new DataRegionId(this.dataRegionId));
        if (dataRegion == null) {
            this.pendingQueue = new ArrayDeque<PipeTsFileInsertionEvent>();
            return;
        }
        dataRegion.writeLock("Pipe: start to extract historical TsFile");
        try {
            Map<Integer, Long> map = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP;
            synchronized (map) {
                long lastFlushedByPipeTime = DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.get(this.dataRegionId);
                if (System.currentTimeMillis() - lastFlushedByPipeTime >= 2000L) {
                    dataRegion.syncCloseAllWorkingTsFileProcessors();
                    DATA_REGION_ID_TO_PIPE_FLUSHED_TIME_MAP.replace(this.dataRegionId, System.currentTimeMillis());
                }
            }
            TsFileManager tsFileManager = dataRegion.getTsFileManager();
            tsFileManager.readLock();
            try {
                this.pendingQueue = new ArrayDeque<PipeTsFileInsertionEvent>(tsFileManager.size(true) + tsFileManager.size(false));
                Collection sequenceFileInsertionEvents = tsFileManager.getTsFileList(true).stream().filter(resource -> resource.isClosed() && !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).map(resource -> new PipeTsFileInsertionEvent((TsFileResource)resource, false, this.pipeTaskMeta, this.pattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime)).collect(Collectors.toList());
                this.pendingQueue.addAll(sequenceFileInsertionEvents);
                Collection unsequenceFileInsertionEvents = tsFileManager.getTsFileList(false).stream().filter(resource -> resource.isClosed() && !this.startIndex.isAfter(resource.getMaxProgressIndexAfterClose()) && this.isTsFileResourceOverlappedWithTimeRange((TsFileResource)resource) && this.isTsFileGeneratedAfterExtractionTimeLowerBound((TsFileResource)resource)).map(resource -> new PipeTsFileInsertionEvent((TsFileResource)resource, false, this.pipeTaskMeta, this.pattern, this.historicalDataExtractionStartTime, this.historicalDataExtractionEndTime)).collect(Collectors.toList());
                this.pendingQueue.addAll(unsequenceFileInsertionEvents);
                this.pendingQueue.forEach(event -> event.increaseReferenceCount(PipeHistoricalDataRegionTsFileExtractor.class.getName()));
                LOGGER.info("Pipe: start to extract historical TsFile, data region {}, sequence file count {}, unsequence file count {}", new Object[]{this.dataRegionId, sequenceFileInsertionEvents.size(), unsequenceFileInsertionEvents.size()});
            }
            finally {
                tsFileManager.readUnlock();
            }
        }
        finally {
            dataRegion.writeUnlock();
        }
    }

    private boolean isTsFileResourceOverlappedWithTimeRange(TsFileResource resource) {
        return resource.getFileEndTime() >= this.historicalDataExtractionStartTime && this.historicalDataExtractionEndTime >= resource.getFileStartTime();
    }

    private boolean isTsFileGeneratedAfterExtractionTimeLowerBound(TsFileResource resource) {
        try {
            return this.historicalDataExtractionTimeLowerBound <= TsFileNameGenerator.getTsFileName(resource.getTsFile().getName()).getTime();
        }
        catch (IOException e) {
            LOGGER.warn(String.format("failed to get the generation time of TsFile %s, extract it anyway", resource.getTsFilePath()), (Throwable)e);
            return true;
        }
    }

    public synchronized Event supply() {
        if (this.pendingQueue == null) {
            return null;
        }
        return this.pendingQueue.poll();
    }

    @Override
    public synchronized boolean hasConsumedAll() {
        return this.pendingQueue != null && this.pendingQueue.isEmpty();
    }

    public synchronized void close() {
        if (this.pendingQueue != null) {
            this.pendingQueue.forEach(event -> event.clearReferenceCount(PipeHistoricalDataRegionTsFileExtractor.class.getName()));
            this.pendingQueue.clear();
            this.pendingQueue = null;
        }
    }
}

