/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.payload.evolvable.builder;

import java.io.IOException;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.PipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.storageengine.dataregion.wal.exception.WALPipeException;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;

public class IoTDBThriftSyncPipeTransferBatchReqBuilder
extends PipeTransferBatchReqBuilder {
    public IoTDBThriftSyncPipeTransferBatchReqBuilder(PipeParameters parameters) {
        super(parameters);
    }

    public boolean onEvent(TabletInsertionEvent event) throws IOException, WALPipeException {
        TPipeTransferReq req = this.buildTabletInsertionReq(event);
        if (this.events.isEmpty() || !((Event)this.events.get(this.events.size() - 1)).equals(event)) {
            this.reqs.add(req);
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).increaseReferenceCount(PipeTransferBatchReqBuilder.class.getName());
            }
            this.events.add(event);
            if (this.firstEventProcessingTime == Long.MIN_VALUE) {
                this.firstEventProcessingTime = System.currentTimeMillis();
            }
            this.bufferSize += (long)req.getBody().length;
        }
        return this.bufferSize >= this.maxBatchSizeInBytes || System.currentTimeMillis() - this.firstEventProcessingTime >= (long)this.maxDelayInMs;
    }

    public void onSuccess() {
        this.reqs.clear();
        for (Event event : this.events) {
            if (!(event instanceof EnrichedEvent)) continue;
            ((EnrichedEvent)event).decreaseReferenceCount(IoTDBThriftSyncConnector.class.getName(), true);
        }
        this.events.clear();
        this.firstEventProcessingTime = Long.MIN_VALUE;
        this.bufferSize = 0L;
    }
}

