/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.utils;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class Binary
implements Comparable<Binary>,
Serializable {
    private static final long serialVersionUID = 6394197743397020735L;
    public static final Binary EMPTY_VALUE = new Binary("");
    private byte[] values;

    public Binary(byte[] v) {
        this.values = v;
    }

    public Binary(String s) {
        this.values = s == null ? null : s.getBytes(TSFileConfig.STRING_CHARSET);
    }

    public static Binary valueOf(String value) {
        return new Binary(BytesUtils.stringToBytes(value));
    }

    @Override
    public int compareTo(Binary other) {
        if (other == null) {
            if (this.values == null) {
                return 0;
            }
            return 1;
        }
        int len1 = this.getLength();
        int len2 = other.getLength();
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            if (this.values[k] == other.values[k]) continue;
            return this.getChar(this.values, k) - this.getChar(other.values, k);
        }
        return len1 - len2;
    }

    private char getChar(byte[] val, int index) {
        return (char)(val[index] & 0xFF);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((Binary)other) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public int getLength() {
        if (this.values == null) {
            return -1;
        }
        return this.values.length;
    }

    public String getStringValue() {
        return new String(this.values, TSFileConfig.STRING_CHARSET);
    }

    public String getTextEncodingType() {
        return "UTF-8";
    }

    public String toString() {
        return this.getStringValue();
    }

    public byte[] getValues() {
        return this.values;
    }

    public void setValues(byte[] values) {
        this.values = values;
    }
}

