/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.iotdb.cli.AbstractCli;
import org.apache.iotdb.cli.utils.IoTPrinter;
import org.apache.iotdb.cli.utils.JlineUtils;
import org.apache.iotdb.exception.ArgsErrorException;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnection;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.thrift.TException;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.UserInterruptException;

public class Cli
extends AbstractCli {
    private static CommandLine commandLine;
    private static LineReader lineReader;

    public static void main(String[] args) throws ClassNotFoundException, IOException {
        Class.forName("org.apache.iotdb.jdbc.IoTDBDriver");
        Options options = Cli.createOptions();
        HelpFormatter hf = new HelpFormatter();
        hf.setWidth(88);
        commandLine = null;
        if (args == null || args.length == 0) {
            IoTPrinter.println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            IoTPrinter.println("For more information, please check the following hint.");
            hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
            System.exit(1);
        }
        Cli.init();
        String[] newArgs = Cli.removePasswordArgs(args);
        String[] newArgs2 = Cli.processExecuteArgs(newArgs);
        boolean continues = Cli.parseCommandLine(options, newArgs2, hf);
        if (!continues) {
            System.exit(1);
        }
        try {
            host = Cli.checkRequiredArg("h", "host", commandLine, false, host);
            port = Cli.checkRequiredArg("p", "port", commandLine, false, port);
            username = Cli.checkRequiredArg("u", "username", commandLine, true, null);
        }
        catch (ArgsErrorException e) {
            IoTPrinter.println("ErrorInput params error because" + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            IoTPrinter.println("ErrorExit cli with error " + e.getMessage());
            System.exit(1);
        }
        lineReader = JlineUtils.getLineReader(username, host, port);
        Cli.serve();
    }

    private static boolean parseCommandLine(Options options, String[] newArgs, HelpFormatter hf) {
        try {
            DefaultParser parser = new DefaultParser();
            commandLine = parser.parse(options, newArgs);
            if (commandLine.hasOption("help")) {
                hf.printHelp("./start-cli.sh(start-cli.bat if Windows)", options, true);
                return false;
            }
            if (commandLine.hasOption("c")) {
                Config.rpcThriftCompressionEnable = true;
            }
            if (commandLine.hasOption("disableISO8601")) {
                timeFormat = RpcUtils.setTimeFormat((String)"long");
            }
            if (commandLine.hasOption("timeout")) {
                Cli.setQueryTimeout(commandLine.getOptionValue("timeout"));
            }
        }
        catch (ParseException e) {
            IoTPrinter.println("Require more params input, eg. ./start-cli.sh(start-cli.bat if Windows) -h xxx.xxx.xxx.xxx -p xxxx -u xxx.");
            IoTPrinter.println("For more information, please check the following hint.");
            hf.printHelp("IoTDB", options, true);
            return false;
        }
        catch (NumberFormatException e) {
            IoTPrinter.println("Error: error format of max print row count, it should be an integer number");
            return false;
        }
        return true;
    }

    private static void serve() {
        try {
            password = commandLine.getOptionValue("pw");
            if (hasExecuteSQL && password != null) {
                Cli.executeSql();
            }
            if (password == null) {
                password = lineReader.readLine("please input your password:", Character.valueOf('\u0000'));
            }
            Cli.receiveCommands(lineReader);
        }
        catch (Exception e) {
            IoTPrinter.println("Error: Exit cli with error: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void executeSql() throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            connection.setQueryTimeout(queryTimeout);
            properties = connection.getServerProperties();
            timestampPrecision = properties.getTimestampPrecision();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            Cli.processCommand(execute, connection);
            System.exit(lastProcessStatus);
        }
        catch (SQLException e) {
            IoTPrinter.println("ErrorCan't execute sql because" + e.getMessage());
            System.exit(1);
        }
    }

    private static void receiveCommands(LineReader reader) throws TException {
        try (IoTDBConnection connection = (IoTDBConnection)DriverManager.getConnection("jdbc:iotdb://" + host + ":" + port + "/", username, password);){
            boolean readLine;
            connection.setQueryTimeout(queryTimeout);
            properties = connection.getServerProperties();
            AGGREGRATE_TIME_LIST.addAll(properties.getSupportedTimeAggregationOperations());
            timestampPrecision = properties.getTimestampPrecision();
            Cli.echoStarting();
            Cli.displayLogo(properties.getLogo(), properties.getVersion(), properties.getBuildInfo());
            IoTPrinter.println(String.format("Successfully login at %s:%s", host, port));
            while (!(readLine = Cli.readerReadLine(reader, connection))) {
            }
        }
        catch (SQLException e) {
            IoTPrinter.println(String.format("%s: %s Host is %s, port is %s.", "Error", e.getMessage(), host, port));
            System.exit(1);
        }
    }

    private static boolean readerReadLine(LineReader reader, IoTDBConnection connection) {
        try {
            String s = reader.readLine("IoTDB> ", null);
            boolean continues = Cli.processCommand(s, connection);
            if (!continues) {
                return true;
            }
        }
        catch (UserInterruptException e) {
            Cli.readLine(reader);
        }
        catch (EndOfFileException e) {
            System.exit(0);
        }
        return false;
    }

    private static void readLine(LineReader reader) {
        try {
            reader.readLine("Press CTRL+C again to exit, or press ENTER to continue", Character.valueOf('\u0000'));
        }
        catch (EndOfFileException | UserInterruptException e2) {
            System.exit(0);
        }
    }
}

