/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkGroupHeader;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.reader.page.PageReader;
import org.apache.iotdb.tsfile.read.reader.page.TimePageReader;
import org.apache.iotdb.tsfile.read.reader.page.ValuePageReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");

    private CompactionUtils() {
    }

    public static void moveTargetFile(List<TsFileResource> targetResources, boolean isInnerSpace, String fullStorageGroupName) throws IOException {
        String fileSuffix = isInnerSpace ? ".inner" : ".cross";
        for (TsFileResource targetResource : targetResources) {
            if (targetResource == null) continue;
            CompactionUtils.moveOneTargetFile(targetResource, fileSuffix, fullStorageGroupName);
        }
    }

    private static void moveOneTargetFile(TsFileResource targetResource, String tmpFileSuffix, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        File newFile = new File(targetResource.getTsFilePath().replace(tmpFileSuffix, ".tsfile"));
        if (!newFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(targetResource.getTsFile(), newFile);
        }
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.closeWithoutSettingStatus();
    }

    public static void combineModsInCrossCompaction(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<TsFileResource> targetResources) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource unseqFile : unseqResources) {
            modifications.addAll(ModificationFile.getCompactionMods(unseqFile).getModifications());
        }
        for (int i = 0; i < targetResources.size(); ++i) {
            TsFileResource targetResource = targetResources.get(i);
            if (targetResource == null) continue;
            HashSet<Modification> seqModifications = new HashSet<Modification>(ModificationFile.getCompactionMods(seqResources.get(i)).getModifications());
            modifications.addAll(seqModifications);
            CompactionUtils.updateOneTargetMods(targetResource, modifications);
            if (!modifications.isEmpty()) {
                FileMetrics.getInstance().increaseModFileNum(1);
                FileMetrics.getInstance().increaseModFileSize(targetResource.getModFile().getSize());
            }
            modifications.removeAll(seqModifications);
        }
    }

    public static void combineModsInInnerCompaction(Collection<TsFileResource> sourceFiles, TsFileResource targetTsFile) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource mergeTsFile : sourceFiles) {
            ModificationFile sourceCompactionModificationFile = ModificationFile.getCompactionMods(mergeTsFile);
            try {
                modifications.addAll(sourceCompactionModificationFile.getModifications());
            }
            finally {
                if (sourceCompactionModificationFile == null) continue;
                sourceCompactionModificationFile.close();
            }
        }
        CompactionUtils.updateOneTargetMods(targetTsFile, modifications);
        if (!modifications.isEmpty()) {
            FileMetrics.getInstance().increaseModFileNum(1);
            FileMetrics.getInstance().increaseModFileSize(targetTsFile.getModFile().getSize());
        }
    }

    private static void updateOneTargetMods(TsFileResource targetFile, Set<Modification> modifications) throws IOException {
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    public static void deleteCompactionModsFile(List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) throws IOException {
        ModificationFile modificationFile;
        for (TsFileResource seqFile : selectedSeqTsFileResourceList) {
            modificationFile = seqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
        for (TsFileResource unseqFile : selectedUnSeqTsFileResourceList) {
            modificationFile = unseqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
    }

    public static boolean deleteTsFilesInDisk(Collection<TsFileResource> mergeTsFiles, String storageGroupName) {
        logger.info("{} [Compaction] Compaction starts to delete real file ", (Object)storageGroupName);
        boolean result = true;
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            if (!mergeTsFile.remove()) {
                result = false;
            }
            logger.info("{} [Compaction] delete TsFile {}", (Object)storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
        return result;
    }

    public static void deleteModificationForSourceFile(Collection<TsFileResource> sourceFiles, String storageGroupName) throws IOException {
        logger.info("{} [Compaction] Start to delete modifications of source files", (Object)storageGroupName);
        for (TsFileResource tsFileResource : sourceFiles) {
            ModificationFile normalModification;
            ModificationFile compactionModificationFile = ModificationFile.getCompactionMods(tsFileResource);
            if (compactionModificationFile.exists()) {
                compactionModificationFile.remove();
            }
            if (!(normalModification = ModificationFile.getNormalMods(tsFileResource)).exists()) continue;
            FileMetrics.getInstance().decreaseModFileNum(1);
            FileMetrics.getInstance().decreaseModFileSize(tsFileResource.getModFile().getSize());
            normalModification.remove();
        }
    }

    public static void updateResource(TsFileResource resource, TsFileIOWriter tsFileIoWriter, String deviceId) {
        List chunkMetadatasOfCurrentDevice = tsFileIoWriter.getChunkMetadataListOfCurrentDeviceInMemory();
        if (chunkMetadatasOfCurrentDevice != null) {
            for (ChunkMetadata chunkMetadata : chunkMetadatasOfCurrentDevice) {
                if (chunkMetadata.getMask() == 64) continue;
                resource.updateStartTime(deviceId, chunkMetadata.getStatistics().getStartTime());
                resource.updateEndTime(deviceId, chunkMetadata.getStatistics().getEndTime());
            }
        }
    }

    public static void updateProgressIndex(List<TsFileResource> targetResources, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        for (TsFileResource targetResource : targetResources) {
            for (TsFileResource unseqResource : unseqResources) {
                targetResource.updateProgressIndex(unseqResource.getMaxProgressIndexAfterClose());
            }
            for (TsFileResource seqResource : seqResources) {
                targetResource.updateProgressIndex(seqResource.getMaxProgressIndexAfterClose());
            }
        }
    }

    public static void updatePlanIndexes(List<TsFileResource> targetResources, List<TsFileResource> seqResources, List<TsFileResource> unseqResources) {
        for (TsFileResource targetResource : targetResources) {
            for (TsFileResource unseqResource : unseqResources) {
                targetResource.updatePlanIndexes(unseqResource);
            }
            for (TsFileResource seqResource : seqResources) {
                targetResource.updatePlanIndexes(seqResource);
            }
        }
    }

    public static boolean validateTsFileResources(TsFileManager manager, String storageGroupName, long timePartition) throws IOException {
        List<TsFileResource> resources = manager.getOrCreateSequenceListByTimePartition(timePartition).getArrayList();
        HashMap<String, Pair> lastEndTimeMap = new HashMap<String, Pair>();
        for (TsFileResource resource : resources) {
            DeviceTimeIndex timeIndex = resource.getTimeIndexType() != 1 ? resource.buildDeviceTimeIndex() : (DeviceTimeIndex)resource.getTimeIndex();
            Set<String> devices = timeIndex.getDevices();
            for (String device : devices) {
                long currentStartTime = timeIndex.getStartTime(device);
                long currentEndTime = timeIndex.getEndTime(device);
                Pair lastDeviceInfo = lastEndTimeMap.computeIfAbsent(device, x -> new Pair(null, (Object)Long.MIN_VALUE));
                long lastEndTime = (Long)lastDeviceInfo.right;
                if (lastEndTime >= currentStartTime) {
                    logger.error("{} Device {} is overlapped between {} and {}, end time in {} is {}, start time in {} is {}", new Object[]{storageGroupName, device, lastDeviceInfo.left, resource, lastDeviceInfo.left, lastEndTime, resource, currentStartTime});
                    return false;
                }
                lastDeviceInfo.left = resource;
                lastDeviceInfo.right = currentEndTime;
                lastEndTimeMap.put(device, lastDeviceInfo);
            }
        }
        return true;
    }

    public static boolean validateTsFiles(List<TsFileResource> tsFileResourceList) {
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (CompactionUtils.validateSingleTsFiles(tsFileResource)) continue;
            return false;
        }
        return true;
    }

    public static boolean validateSingleTsFiles(TsFileResource resource) {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(resource.getTsFilePath());){
            byte marker;
            reader.readHeadMagic();
            reader.readTailMagic();
            reader.position((long)"TsFile".getBytes().length + 1L);
            ArrayList<long[]> timeBatch = new ArrayList<long[]>();
            int pageIndex = 0;
            block12: while ((marker = reader.readMarker()) != 2) {
                switch (marker) {
                    case -127: 
                    case -123: 
                    case 1: 
                    case 5: 
                    case 65: 
                    case 69: {
                        ChunkHeader header = reader.readChunkHeader(marker);
                        if (header.getDataSize() == 0) continue block12;
                        Decoder defaultTimeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                        Decoder valueDecoder = Decoder.getDecoderByType((TSEncoding)header.getEncodingType(), (TSDataType)header.getDataType());
                        int dataSize = header.getDataSize();
                        pageIndex = 0;
                        if (header.getDataType() == TSDataType.VECTOR) {
                            timeBatch.clear();
                        }
                        while (dataSize > 0) {
                            TsPrimitiveType[] tsPrimitiveTypeArray;
                            valueDecoder.reset();
                            PageHeader pageHeader = reader.readPageHeader(header.getDataType(), (header.getChunkType() & 0x3F) == 1);
                            ByteBuffer pageData = reader.readPage(pageHeader, header.getCompressionType());
                            if ((header.getChunkType() & 0xFFFFFF80) == -128) {
                                TimePageReader timePageReader = new TimePageReader(pageHeader, pageData, defaultTimeDecoder);
                                timeBatch.add(timePageReader.getNextTimeBatch());
                            } else if ((header.getChunkType() & 0x40) == 64) {
                                ValuePageReader valuePageReader = new ValuePageReader(pageHeader, pageData, header.getDataType(), valueDecoder);
                                tsPrimitiveTypeArray = valuePageReader.nextValueBatch((long[])timeBatch.get(pageIndex));
                            } else {
                                PageReader pageReader = new PageReader(pageData, header.getDataType(), valueDecoder, defaultTimeDecoder, null);
                                tsPrimitiveTypeArray = pageReader.getAllSatisfiedPageData();
                            }
                            ++pageIndex;
                            dataSize -= pageHeader.getSerializedPageSize();
                        }
                        continue block12;
                    }
                    case 0: {
                        ChunkGroupHeader chunkGroupHeader = reader.readChunkGroupHeader();
                        continue block12;
                    }
                    case 4: {
                        reader.readPlanIndex();
                        continue block12;
                    }
                }
                MetaMarker.handleUnexpectedMarker((byte)marker);
            }
            for (String device : reader.getAllDevices()) {
                Map map = reader.readChunkMetadataInDevice(device);
            }
        }
        catch (Exception e) {
            logger.error("Meets error when validating TsFile {}, ", (Object)resource.getTsFilePath(), (Object)e);
            return false;
        }
        return true;
    }
}

