/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRegionIdStatement
extends Statement
implements IConfigStatement {
    private String database;
    private String device;
    private final TConsensusGroupType partitionType;
    private long timeStamp = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(GetRegionIdStatement.class);

    public GetRegionIdStatement(TConsensusGroupType partitionType) {
        this.partitionType = partitionType;
    }

    public String getDatabase() {
        return this.database;
    }

    public TConsensusGroupType getPartitionType() {
        return this.partitionType;
    }

    public String getDevice() {
        return this.device;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setDevice(String device) {
        this.device = device;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitGetRegionId(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    @Override
    public List<PartialPath> getPaths() {
        if (this.database == null) {
            return new ArrayList<PartialPath>();
        }
        try {
            return Collections.singletonList(new PartialPath(this.database));
        }
        catch (IllegalPathException e) {
            LOGGER.warn("illegal path: {}", (Object)this.database);
            return new ArrayList<PartialPath>();
        }
    }
}

