/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.distribution;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.planner.distribution.NodeDistribution;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SourceNode;

public class NodeGroupContext {
    protected final MPPQueryContext queryContext;
    private final Map<PlanNodeId, NodeDistribution> nodeDistributionMap;
    private final boolean isAlignByDevice;
    private final TRegionReplicaSet mostlyUsedDataRegion;
    protected boolean hasExchangeNode;

    public NodeGroupContext(MPPQueryContext queryContext, boolean isAlignByDevice, PlanNode root) {
        this.queryContext = queryContext;
        this.nodeDistributionMap = new HashMap<PlanNodeId, NodeDistribution>();
        this.isAlignByDevice = isAlignByDevice;
        this.mostlyUsedDataRegion = isAlignByDevice ? this.getMostlyUsedDataRegion(root) : null;
        this.hasExchangeNode = false;
    }

    private TRegionReplicaSet getMostlyUsedDataRegion(PlanNode root) {
        HashMap<TRegionReplicaSet, Long> regionCount = new HashMap<TRegionReplicaSet, Long>();
        this.countRegionOfSourceNodes(root, regionCount);
        if (regionCount.isEmpty()) {
            return DataPartition.NOT_ASSIGNED;
        }
        return (TRegionReplicaSet)Collections.max(regionCount.entrySet(), Map.Entry.comparingByValue()).getKey();
    }

    private void countRegionOfSourceNodes(PlanNode root, Map<TRegionReplicaSet, Long> result) {
        TRegionReplicaSet regionReplicaSet;
        root.getChildren().forEach(child -> this.countRegionOfSourceNodes((PlanNode)child, result));
        if (root instanceof SourceNode && (regionReplicaSet = ((SourceNode)root).getRegionReplicaSet()) != DataPartition.NOT_ASSIGNED) {
            result.compute(regionReplicaSet, (region, count) -> count == null ? 1L : count + 1L);
        }
    }

    public void putNodeDistribution(PlanNodeId nodeId, NodeDistribution distribution) {
        this.nodeDistributionMap.put(nodeId, distribution);
    }

    public NodeDistribution getNodeDistribution(PlanNodeId nodeId) {
        return this.nodeDistributionMap.get(nodeId);
    }

    public boolean isAlignByDevice() {
        return this.isAlignByDevice;
    }

    public TRegionReplicaSet getMostlyUsedDataRegion() {
        return this.mostlyUsedDataRegion;
    }
}

