/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.optimization;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FillNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.MultiChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.FillPolicy;
import org.apache.iotdb.db.queryengine.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;

public class LimitOffsetPushDown
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Analysis analysis, MPPQueryContext context) {
        if (analysis.getStatement().getType() != StatementType.QUERY) {
            return plan;
        }
        QueryStatement queryStatement = (QueryStatement)analysis.getStatement();
        if (queryStatement.isLastQuery() || queryStatement.isAggregationQuery() || !queryStatement.hasLimit() && !queryStatement.hasOffset()) {
            return plan;
        }
        return plan.accept(new Rewriter(), new RewriterContext(analysis));
    }

    public static boolean canPushDownLimitOffsetToGroupByTime(QueryStatement queryStatement) {
        if (queryStatement.isGroupByTime() && !queryStatement.isAlignByDevice() && !queryStatement.hasHaving() && !queryStatement.hasFill()) {
            return !queryStatement.hasOrderBy() || queryStatement.isOrderByBasedOnTime();
        }
        return false;
    }

    public static void pushDownLimitOffsetToTimeParameter(QueryStatement queryStatement) {
        GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
        long startTime = groupByTimeComponent.getStartTime();
        long endTime = groupByTimeComponent.getEndTime();
        long step = groupByTimeComponent.getSlidingStep();
        long interval = groupByTimeComponent.getInterval();
        long size = (endTime - startTime + step - 1L) / step;
        if (size > queryStatement.getRowOffset()) {
            long limitSize = queryStatement.getRowLimit();
            long offsetSize = queryStatement.getRowOffset();
            startTime = queryStatement.getResultTimeOrder() == Ordering.ASC ? (startTime += offsetSize * step) : (startTime += (size - offsetSize - limitSize) * step);
            endTime = limitSize == 0L ? endTime : Math.min(endTime, startTime + (limitSize - 1L) * step + interval);
            groupByTimeComponent.setEndTime(endTime);
            groupByTimeComponent.setStartTime(startTime);
        } else {
            queryStatement.setResultSetEmpty(true);
        }
        queryStatement.setRowLimit(0L);
        queryStatement.setRowOffset(0L);
    }

    public static boolean canPushDownLimitOffsetInGroupByTimeForDevice(QueryStatement queryStatement) {
        if (!LimitOffsetPushDown.hasLimitOffset(queryStatement)) {
            return false;
        }
        if (queryStatement.isGroupByTime() && queryStatement.isAlignByDevice() && !queryStatement.hasHaving() && !queryStatement.hasFill()) {
            return !queryStatement.hasOrderBy() || queryStatement.isOrderByBasedOnDevice();
        }
        return false;
    }

    public static List<PartialPath> pushDownLimitOffsetInGroupByTimeForDevice(List<PartialPath> deviceNames, QueryStatement queryStatement) {
        int index;
        GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
        long startTime = groupByTimeComponent.getStartTime();
        long endTime = groupByTimeComponent.getEndTime();
        long size = (endTime - startTime + groupByTimeComponent.getSlidingStep() - 1L) / groupByTimeComponent.getSlidingStep();
        if (size == 0L || size * (long)deviceNames.size() <= queryStatement.getRowOffset()) {
            queryStatement.setResultSetEmpty(true);
            return deviceNames;
        }
        long limitSize = queryStatement.getRowLimit();
        long offsetSize = queryStatement.getRowOffset();
        ArrayList<PartialPath> optimizedDeviceNames = new ArrayList<PartialPath>();
        int startDeviceIndex = (int)(offsetSize / size);
        int endDeviceIndex = limitSize == 0L ? deviceNames.size() - 1 : (int)((limitSize - ((long)(startDeviceIndex + 1) * size - offsetSize) + size - 1L) / size + (long)startDeviceIndex);
        for (index = 0; index < startDeviceIndex; ++index) {
        }
        queryStatement.setRowOffset(offsetSize - (long)startDeviceIndex * size);
        if (startDeviceIndex == endDeviceIndex) {
            optimizedDeviceNames.add(deviceNames.get(startDeviceIndex));
            if (LimitOffsetPushDown.hasLimitOffset(queryStatement) && queryStatement.isOrderByTimeInDevices()) {
                LimitOffsetPushDown.pushDownLimitOffsetToTimeParameter(queryStatement);
            }
        } else {
            while (index <= endDeviceIndex && index < deviceNames.size()) {
                optimizedDeviceNames.add(deviceNames.get(index));
                ++index;
            }
        }
        return optimizedDeviceNames;
    }

    private static boolean hasLimitOffset(QueryStatement queryStatement) {
        return queryStatement.hasLimit() || queryStatement.hasOffset();
    }

    private static class RewriterContext {
        private long limit;
        private long offset;
        private boolean enablePushDown = true;
        private PlanNode parent;
        private final Analysis analysis;

        public RewriterContext(Analysis analysis) {
            this.analysis = analysis;
        }

        public long getLimit() {
            return this.limit;
        }

        public void setLimit(long limit) {
            this.limit = limit;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public boolean isEnablePushDown() {
            return this.enablePushDown;
        }

        public void setEnablePushDown(boolean enablePushDown) {
            this.enablePushDown = enablePushDown;
        }

        public PlanNode getParent() {
            return this.parent;
        }

        public void setParent(PlanNode parent) {
            this.parent = parent;
        }

        public Analysis getAnalysis() {
            return this.analysis;
        }
    }

    private static class Rewriter
    extends PlanVisitor<PlanNode, RewriterContext> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitPlan(PlanNode node, RewriterContext context) {
            for (PlanNode child : node.getChildren()) {
                context.setParent(node);
                child.accept(this, context);
            }
            return node;
        }

        @Override
        public PlanNode visitLimit(LimitNode node, RewriterContext context) {
            PlanNode parent = context.getParent();
            context.setParent(node);
            context.setLimit(node.getLimit());
            node.getChild().accept(this, context);
            if (context.isEnablePushDown()) {
                return this.concatParentWithChild(parent, node.getChild());
            }
            return node;
        }

        @Override
        public PlanNode visitOffset(OffsetNode node, RewriterContext context) {
            PlanNode parent = context.getParent();
            context.setParent(node);
            context.setOffset(node.getOffset());
            node.getChild().accept(this, context);
            if (context.isEnablePushDown()) {
                return this.concatParentWithChild(parent, node.getChild());
            }
            return node;
        }

        private PlanNode concatParentWithChild(PlanNode parent, PlanNode child) {
            if (parent != null) {
                ((SingleChildProcessNode)parent).setChild(child);
                return parent;
            }
            return child;
        }

        @Override
        public PlanNode visitFill(FillNode node, RewriterContext context) {
            FillPolicy fillPolicy = node.getFillDescriptor().getFillPolicy();
            if (fillPolicy == FillPolicy.VALUE) {
                node.getChild().accept(this, context);
            } else {
                context.setEnablePushDown(false);
            }
            return node;
        }

        @Override
        public PlanNode visitFilter(FilterNode node, RewriterContext context) {
            context.setEnablePushDown(false);
            return node;
        }

        @Override
        public PlanNode visitTransform(TransformNode node, RewriterContext context) {
            Expression[] outputExpressions = node.getOutputExpressions();
            boolean enablePushDown = true;
            for (Expression expression : outputExpressions) {
                if (ExpressionAnalyzer.checkIsScalarExpression(expression, context.getAnalysis())) continue;
                enablePushDown = false;
                break;
            }
            if (enablePushDown) {
                node.getChild().accept(this, context);
            } else {
                context.setEnablePushDown(false);
            }
            return node;
        }

        @Override
        public PlanNode visitMultiChildProcess(MultiChildProcessNode node, RewriterContext context) {
            context.setEnablePushDown(false);
            return node;
        }

        @Override
        public PlanNode visitDeviceView(DeviceViewNode node, RewriterContext context) {
            if (node.getChildren().size() == 1) {
                node.getChildren().get(0).accept(this, context);
                return node;
            }
            return this.visitMultiChildProcess((MultiChildProcessNode)node, context);
        }

        @Override
        public PlanNode visitSeriesScan(SeriesScanNode node, RewriterContext context) {
            if (context.isEnablePushDown()) {
                node.setLimit(context.getLimit());
                node.setOffset(context.getOffset());
            }
            return node;
        }

        @Override
        public PlanNode visitAlignedSeriesScan(AlignedSeriesScanNode node, RewriterContext context) {
            if (context.isEnablePushDown()) {
                node.setLimit(context.getLimit());
                node.setOffset(context.getOffset());
            }
            return node;
        }
    }
}

