/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.AdditionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.EqualToExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.GreaterThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LessThanExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicAndExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.LogicOrExpression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.WhenThenExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimestampOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ExpressionFactory {
    private ExpressionFactory() {
    }

    public static PartialPath path(String pathStr) throws IllegalPathException {
        return new PartialPath(pathStr);
    }

    public static TimeSeriesOperand timeSeries(String pathStr) throws IllegalPathException {
        PartialPath path = new PartialPath(pathStr);
        return new TimeSeriesOperand(path);
    }

    public static TimeSeriesOperand timeSeries(PartialPath path) {
        return new TimeSeriesOperand(path);
    }

    public static ConstantOperand constant(TSDataType dataType, String valueString) {
        return new ConstantOperand(dataType, valueString);
    }

    public static ConstantOperand intValue(String valueString) {
        return new ConstantOperand(TSDataType.INT32, valueString);
    }

    public static TimestampOperand time() {
        return new TimestampOperand();
    }

    public static FunctionExpression function(String functionName, LinkedHashMap<String, String> functionAttributes, Expression ... inputExpression) {
        return new FunctionExpression(functionName, functionAttributes, Arrays.asList(inputExpression));
    }

    public static FunctionExpression function(String functionName, Expression ... inputExpression) {
        return new FunctionExpression(functionName, new LinkedHashMap<String, String>(), Arrays.asList(inputExpression));
    }

    public static FunctionExpression count(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.COUNT.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static FunctionExpression countTime(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.COUNT_TIME.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static FunctionExpression sum(Expression inputExpression) {
        return new FunctionExpression(TAggregationType.SUM.toString(), new LinkedHashMap<String, String>(), Collections.singletonList(inputExpression));
    }

    public static LogicAndExpression and(Expression leftExpression, Expression rightExpression) {
        return new LogicAndExpression(leftExpression, rightExpression);
    }

    public static LogicOrExpression or(Expression leftExpression, Expression rightExpression) {
        return new LogicOrExpression(leftExpression, rightExpression);
    }

    public static AdditionExpression add(Expression leftExpression, Expression rightExpression) {
        return new AdditionExpression(leftExpression, rightExpression);
    }

    public static GreaterThanExpression gt(Expression leftExpression, Expression rightExpression) {
        return new GreaterThanExpression(leftExpression, rightExpression);
    }

    public static LessThanExpression lt(Expression leftExpression, Expression rightExpression) {
        return new LessThanExpression(leftExpression, rightExpression);
    }

    public static EqualToExpression eq(Expression leftExpression, Expression rightExpression) {
        return new EqualToExpression(leftExpression, rightExpression);
    }

    public static WhenThenExpression whenThen(Expression whenExpression, Expression thenExpression) {
        return new WhenThenExpression(whenExpression, thenExpression);
    }
}

