/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.AvgAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.BinaryModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.BooleanModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.CountAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.CountIfAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.CountTimeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.DoubleModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.ExtremeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.FirstValueAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.FirstValueDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.FloatModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.IntModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.LastValueAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.LastValueDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.LongModeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MaxTimeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MaxTimeDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MaxValueAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MinTimeAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MinTimeDescAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.MinValueAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.SumAccumulator;
import org.apache.iotdb.db.queryengine.execution.aggregation.TimeDurationAccumulator;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.CompareBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.ConstantOperand;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AccumulatorFactory {
    public static Accumulator createAccumulator(TAggregationType aggregationType, TSDataType tsDataType, List<Expression> inputExpressions, Map<String, String> inputAttributes, boolean ascending) {
        switch (aggregationType) {
            case COUNT: {
                return new CountAccumulator();
            }
            case AVG: {
                return new AvgAccumulator(tsDataType);
            }
            case SUM: {
                return new SumAccumulator(tsDataType);
            }
            case EXTREME: {
                return new ExtremeAccumulator(tsDataType);
            }
            case MAX_TIME: {
                return ascending ? new MaxTimeAccumulator() : new MaxTimeDescAccumulator();
            }
            case MIN_TIME: {
                return ascending ? new MinTimeAccumulator() : new MinTimeDescAccumulator();
            }
            case MAX_VALUE: {
                return new MaxValueAccumulator(tsDataType);
            }
            case MIN_VALUE: {
                return new MinValueAccumulator(tsDataType);
            }
            case LAST_VALUE: {
                return ascending ? new LastValueAccumulator(tsDataType) : new LastValueDescAccumulator(tsDataType);
            }
            case FIRST_VALUE: {
                return ascending ? new FirstValueAccumulator(tsDataType) : new FirstValueDescAccumulator(tsDataType);
            }
            case COUNT_IF: {
                return new CountIfAccumulator(AccumulatorFactory.initKeepEvaluator(inputExpressions.get(1)), Boolean.parseBoolean(inputAttributes.getOrDefault("ignoreNull", "true")));
            }
            case TIME_DURATION: {
                return new TimeDurationAccumulator();
            }
            case MODE: {
                return AccumulatorFactory.crateModeAccumulator(tsDataType);
            }
            case COUNT_TIME: {
                return new CountTimeAccumulator();
            }
        }
        throw new IllegalArgumentException("Invalid Aggregation function: " + aggregationType);
    }

    private static Accumulator crateModeAccumulator(TSDataType tsDataType) {
        switch (tsDataType) {
            case BOOLEAN: {
                return new BooleanModeAccumulator();
            }
            case TEXT: {
                return new BinaryModeAccumulator();
            }
            case INT32: {
                return new IntModeAccumulator();
            }
            case INT64: {
                return new LongModeAccumulator();
            }
            case FLOAT: {
                return new FloatModeAccumulator();
            }
            case DOUBLE: {
                return new DoubleModeAccumulator();
            }
        }
        throw new IllegalArgumentException("Unknown data type: " + tsDataType);
    }

    public static List<Accumulator> createAccumulators(List<TAggregationType> aggregationTypes, TSDataType tsDataType, List<Expression> inputExpressions, Map<String, String> inputAttributes, boolean ascending) {
        ArrayList<Accumulator> accumulators = new ArrayList<Accumulator>();
        for (TAggregationType aggregationType : aggregationTypes) {
            accumulators.add(AccumulatorFactory.createAccumulator(aggregationType, tsDataType, inputExpressions, inputAttributes, ascending));
        }
        return accumulators;
    }

    public static KeepEvaluator initKeepEvaluator(Expression keepExpression) {
        if (keepExpression instanceof ConstantOperand) {
            return keep -> keep >= Long.parseLong(keepExpression.getExpressionString());
        }
        long constant = Long.parseLong(((CompareBinaryExpression)keepExpression).getRightExpression().getExpressionString());
        switch (keepExpression.getExpressionType()) {
            case LESS_THAN: {
                return keep -> keep < constant;
            }
            case LESS_EQUAL: {
                return keep -> keep <= constant;
            }
            case GREATER_THAN: {
                return keep -> keep > constant;
            }
            case GREATER_EQUAL: {
                return keep -> keep >= constant;
            }
            case EQUAL_TO: {
                return keep -> keep == constant;
            }
            case NON_EQUAL: {
                return keep -> keep != constant;
            }
        }
        throw new IllegalArgumentException("unsupported expression type: " + (Object)((Object)keepExpression.getExpressionType()));
    }

    @FunctionalInterface
    public static interface KeepEvaluator {
        public boolean apply(long var1);
    }
}

