/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.subtask.connector;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.db.pipe.connector.protocol.legacy.IoTDBLegacyPipeConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.IoTDBThriftAsyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBThriftSyncConnector;
import org.apache.iotdb.db.pipe.connector.protocol.websocket.WebSocketConnector;
import org.apache.iotdb.db.pipe.execution.executor.PipeConnectorSubtaskExecutor;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtask;
import org.apache.iotdb.db.pipe.task.subtask.connector.PipeConnectorSubtaskLifeCycle;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeConnectorSubtaskManager {
    private static final String FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE = "Failed to deregister PipeConnectorSubtask. No such subtask: ";
    private final Map<String, PipeConnectorSubtaskLifeCycle> attributeSortedString2SubtaskLifeCycleMap = new HashMap<String, PipeConnectorSubtaskLifeCycle>();

    public synchronized String register(PipeConnectorSubtaskExecutor executor, PipeParameters pipeConnectorParameters, PipeRuntimeEnvironment pipeRuntimeEnvironment) {
        String attributeSortedString = new TreeMap(pipeConnectorParameters.getAttribute()).toString();
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            String connectorKey = pipeConnectorParameters.getStringOrDefault("connector", BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName());
            Object pipeConnector = connectorKey.equals(BuiltinPipePlugin.IOTDB_THRIFT_CONNECTOR.getPipePluginName()) || connectorKey.equals(BuiltinPipePlugin.IOTDB_THRIFT_SYNC_CONNECTOR.getPipePluginName()) ? new IoTDBThriftSyncConnector() : (connectorKey.equals(BuiltinPipePlugin.IOTDB_THRIFT_ASYNC_CONNECTOR.getPipePluginName()) ? new IoTDBThriftAsyncConnector() : (connectorKey.equals(BuiltinPipePlugin.IOTDB_LEGACY_PIPE_CONNECTOR.getPipePluginName()) ? new IoTDBLegacyPipeConnector() : (connectorKey.equals(BuiltinPipePlugin.WEBSOCKET_CONNECTOR.getPipePluginName()) ? new WebSocketConnector() : PipeAgent.plugin().reflectConnector(pipeConnectorParameters))));
            try {
                pipeConnector.validate(new PipeParameterValidator(pipeConnectorParameters));
                pipeConnector.customize(pipeConnectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration(pipeRuntimeEnvironment));
                pipeConnector.handshake();
            }
            catch (Exception e) {
                throw new PipeException("Failed to construct PipeConnector, because of " + e.getMessage(), (Throwable)e);
            }
            BoundedBlockingPendingQueue<Event> pendingQueue = new BoundedBlockingPendingQueue<Event>(PipeConfig.getInstance().getPipeConnectorPendingQueueSize());
            PipeConnectorSubtask pipeConnectorSubtask = new PipeConnectorSubtask(attributeSortedString, pendingQueue, (PipeConnector)pipeConnector);
            PipeConnectorSubtaskLifeCycle pipeConnectorSubtaskLifeCycle = new PipeConnectorSubtaskLifeCycle(executor, pipeConnectorSubtask, pendingQueue);
            this.attributeSortedString2SubtaskLifeCycleMap.put(attributeSortedString, pipeConnectorSubtaskLifeCycle);
        }
        this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).register();
        return attributeSortedString;
    }

    public synchronized void deregister(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        if (this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).deregister()) {
            this.attributeSortedString2SubtaskLifeCycleMap.remove(attributeSortedString);
        }
    }

    public synchronized void start(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).start();
    }

    public synchronized void stop(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException(FAILED_TO_DEREGISTER_EXCEPTION_MESSAGE + attributeSortedString);
        }
        this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).stop();
    }

    public BoundedBlockingPendingQueue<Event> getPipeConnectorPendingQueue(String attributeSortedString) {
        if (!this.attributeSortedString2SubtaskLifeCycleMap.containsKey(attributeSortedString)) {
            throw new PipeException("Failed to get PendingQueue. No such subtask: " + attributeSortedString);
        }
        return this.attributeSortedString2SubtaskLifeCycleMap.get(attributeSortedString).getPendingQueue();
    }

    private PipeConnectorSubtaskManager() {
    }

    public static PipeConnectorSubtaskManager instance() {
        return PipeSubtaskManagerHolder.INSTANCE;
    }

    private static class PipeSubtaskManagerHolder {
        private static final PipeConnectorSubtaskManager INSTANCE = new PipeConnectorSubtaskManager();

        private PipeSubtaskManagerHolder() {
        }
    }
}

