/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.heartbeat;

import com.lmax.disruptor.RingBuffer;
import java.util.Deque;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.task.connection.UnboundedBlockingPendingQueue;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeHeartbeatEvent
extends EnrichedEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeHeartbeatEvent.class);
    private final String dataRegionId;
    private String pipeName;
    private long timePublished;
    private long timeAssigned;
    private long timeProcessed;
    private long timeTransferred;
    private int disruptorSize;
    private int extractorQueueSize;
    private int bufferQueueSize;
    private int connectorQueueSize;
    private final boolean shouldPrintMessage;

    public PipeHeartbeatEvent(String dataRegionId, boolean shouldPrintMessage) {
        super(null, null);
        this.dataRegionId = dataRegionId;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    public PipeHeartbeatEvent(String dataRegionId, long timePublished, boolean shouldPrintMessage) {
        super(null, null);
        this.dataRegionId = dataRegionId;
        this.timePublished = timePublished;
        this.shouldPrintMessage = shouldPrintMessage;
    }

    @Override
    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        return true;
    }

    @Override
    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        if (this.shouldPrintMessage && this.pipeName != null && LOGGER.isInfoEnabled()) {
            LOGGER.info(this.toString());
        }
        return true;
    }

    @Override
    public ProgressIndex getProgressIndex() {
        return MinimumProgressIndex.INSTANCE;
    }

    @Override
    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(PipeTaskMeta pipeTaskMeta, String pattern) {
        return new PipeHeartbeatEvent(this.dataRegionId, this.timePublished, this.shouldPrintMessage);
    }

    @Override
    public boolean isGeneratedByPipe() {
        return false;
    }

    public boolean isShouldPrintMessage() {
        return this.shouldPrintMessage;
    }

    public void bindPipeName(String pipeName) {
        if (this.shouldPrintMessage) {
            this.pipeName = pipeName;
        }
    }

    public void onPublished() {
        if (this.shouldPrintMessage) {
            this.timePublished = System.currentTimeMillis();
        }
    }

    public void onAssigned() {
        if (this.shouldPrintMessage) {
            this.timeAssigned = System.currentTimeMillis();
        }
    }

    public void onProcessed() {
        if (this.shouldPrintMessage) {
            this.timeProcessed = System.currentTimeMillis();
        }
    }

    public void onTransferred() {
        if (this.shouldPrintMessage) {
            this.timeTransferred = System.currentTimeMillis();
        }
    }

    public void recordDisruptorSize(RingBuffer<?> ringBuffer) {
        if (this.shouldPrintMessage) {
            this.disruptorSize = ringBuffer.getBufferSize() - (int)ringBuffer.remainingCapacity();
        }
    }

    public void recordExtractorQueueSize(UnboundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.extractorQueueSize = pendingQueue.size();
        }
    }

    public void recordBufferQueueSize(Deque<Event> bufferQueue) {
        if (this.shouldPrintMessage) {
            this.bufferQueueSize = bufferQueue.size();
        }
    }

    public void recordConnectorQueueSize(BoundedBlockingPendingQueue<Event> pendingQueue) {
        if (this.shouldPrintMessage) {
            this.connectorQueueSize = pendingQueue.size();
        }
    }

    public String toString() {
        String unknownMessage = "Unknown";
        String publishedToAssignedMessage = this.timeAssigned != 0L ? this.timeAssigned - this.timePublished + "ms" : "Unknown";
        String assignedToProcessedMessage = this.timeProcessed != 0L ? this.timeProcessed - this.timeAssigned + "ms" : "Unknown";
        String processedToTransferredMessage = this.timeTransferred != 0L ? this.timeTransferred - this.timeProcessed + "ms" : "Unknown";
        String totalTimeMessage = this.timeTransferred != 0L ? this.timeTransferred - this.timePublished + "ms" : "Unknown";
        String disruptorSizeMessage = Integer.toString(this.disruptorSize);
        String extractorQueueSizeMessage = this.timeAssigned != 0L ? Integer.toString(this.extractorQueueSize) : "Unknown";
        String bufferQueueSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.bufferQueueSize) : "Unknown";
        String connectorQueueSizeMessage = this.timeProcessed != 0L ? Integer.toString(this.connectorQueueSize) : "Unknown";
        return "PipeHeartbeatEvent{pipeName='" + this.pipeName + "', dataRegionId=" + this.dataRegionId + ", startTime=" + DateTimeUtils.convertLongToDate(this.timePublished, "ms") + ", publishedToAssigned=" + publishedToAssignedMessage + ", assignedToProcessed=" + assignedToProcessedMessage + ", processedToTransferred=" + processedToTransferredMessage + ", totalTimeCost=" + totalTimeMessage + ", disruptorSize=" + disruptorSizeMessage + ", extractorQueueSize=" + extractorQueueSizeMessage + ", bufferQueueSize=" + bufferQueueSizeMessage + ", connectorQueueSize=" + connectorQueueSizeMessage + "}";
    }
}

