/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.schemaregion.SchemaRegionStateMachine;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;

public class SchemaRegionConsensusImpl {
    private SchemaRegionConsensusImpl() {
    }

    public static IConsensus getInstance() {
        return SchemaRegionConsensusImplHolder.INSTANCE;
    }

    private static class SchemaRegionConsensusImplHolder {
        private static final IoTDBConfig CONF = IoTDBDescriptor.getInstance().getConfig();
        private static final IConsensus INSTANCE = (IConsensus)ConsensusFactory.getConsensusImpl((String)CONF.getSchemaRegionConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(CONF.getDataNodeId()).setThisNode(new TEndPoint(CONF.getInternalAddress(), CONF.getSchemaRegionConsensusPort())).setConsensusGroupType(TConsensusGroupType.SchemaRegion).setRatisConfig(RatisConfig.newBuilder().setSnapshot(RatisConfig.Snapshot.newBuilder().setAutoTriggerThreshold(CONF.getSchemaRatisConsensusSnapshotTriggerThreshold()).build()).setLog(RatisConfig.Log.newBuilder().setUnsafeFlushEnabled(CONF.isSchemaRatisConsensusLogUnsafeFlushEnable()).setForceSyncNum(CONF.getSchemaRatisConsensusLogForceSyncNum()).setSegmentSizeMax(SizeInBytes.valueOf((long)CONF.getSchemaRatisConsensusLogSegmentSizeMax())).setPreserveNumsWhenPurge(CONF.getSchemaRatisConsensusPreserveWhenPurge()).build()).setGrpc(RatisConfig.Grpc.newBuilder().setFlowControlWindow(SizeInBytes.valueOf((long)CONF.getSchemaRatisConsensusGrpcFlowControlWindow())).setLeaderOutstandingAppendsMax(CONF.getSchemaRatisConsensusGrpcLeaderOutstandingAppendsMax()).build()).setRpc(RatisConfig.Rpc.newBuilder().setTimeoutMin(TimeDuration.valueOf((long)CONF.getSchemaRatisConsensusLeaderElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setTimeoutMax(TimeDuration.valueOf((long)CONF.getSchemaRatisConsensusLeaderElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setRequestTimeout(TimeDuration.valueOf((long)CONF.getSchemaRatisConsensusRequestTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMin(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMax(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setClient(RatisConfig.Client.newBuilder().setClientRequestTimeoutMillis(CONF.getDataRatisConsensusRequestTimeoutMs()).setClientMaxRetryAttempt(CONF.getDataRatisConsensusMaxRetryAttempts()).setClientRetryInitialSleepTimeMs(CONF.getDataRatisConsensusInitialSleepTimeMs()).setClientRetryMaxSleepTimeMs(CONF.getDataRatisConsensusMaxSleepTimeMs()).setCoreClientNumForEachNode(CONF.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).build()).setImpl(RatisConfig.Impl.newBuilder().setTriggerSnapshotFileSize(CONF.getSchemaRatisLogMax()).build()).setLeaderLogAppender(RatisConfig.LeaderLogAppender.newBuilder().setBufferByteLimit(CONF.getSchemaRatisConsensusLogAppenderBufferSizeMax()).build()).setRead(RatisConfig.Read.newBuilder().setReadTimeout(TimeDuration.valueOf((long)CONF.getConnectionTimeoutInMS(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).build()).setStorageDir(CONF.getSchemaRegionConsensusDir()).build(), gid -> new SchemaRegionStateMachine(SchemaEngine.getInstance().getSchemaRegion((SchemaRegionId)gid))).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", CONF.getSchemaRegionConsensusProtocolClass())));

        private SchemaRegionConsensusImplHolder() {
        }
    }
}

