/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.conf.IoTDBConstant;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALMode;
import org.apache.iotdb.db.storageengine.rescon.disk.DirectoryChecker;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBStartCheck {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBStartCheck.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final CommonConfig commonConfig = CommonDescriptor.getInstance().getConfig();
    public static final String PROPERTIES_FILE_NAME = "system.properties";
    private static final String SCHEMA_DIR = config.getSchemaDir();
    private boolean isFirstStart = false;
    private final File propertiesFile;
    private final File oldPropertiesFile;
    private final File tmpPropertiesFile;
    private final Properties properties = new Properties();
    private final Map<String, Supplier<String>> systemProperties = new HashMap<String, Supplier<String>>();
    private static final String SYSTEM_PROPERTIES_STRING = "System properties:";
    private static final String DATA_REGION_NUM = "data_region_num";
    private static final String INTERNAL_ADDRESS = "dn_internal_address";
    private static final String INTERNAL_PORT = "dn_internal_port";
    private static final String RPC_ADDRESS = "dn_rpc_address";
    private static final String RPC_PORT = "dn_rpc_port";
    private static final String MPP_DATA_EXCHANGE_PORT = "dn_mpp_data_exchange_port";
    private static final String SCHEMA_REGION_CONSENSUS_PORT = "dn_schema_region_consensus_port";
    private static final String DATA_REGION_CONSENSUS_PORT = "dn_data_region_consensus_port";
    private static final Map<String, Supplier<String>> variableParamValueTable = new HashMap<String, Supplier<String>>();
    private static final String IOTDB_VERSION_STRING = "iotdb_version";
    private static final String COMMIT_ID_STRING = "commit_id";
    private static final String DATA_NODE_ID = "data_node_id";
    private static final String SCHEMA_REGION_CONSENSUS_PROTOCOL = "schema_region_consensus_protocol";
    private static final String DATA_REGION_CONSENSUS_PROTOCOL = "data_region_consensus_protocol";
    private static final String VIRTUAL_STORAGE_GROUP_NUM = "virtual_storage_group_num";

    public static IoTDBStartCheck getInstance() {
        return IoTDBConfigCheckHolder.INSTANCE;
    }

    private String getVal(String paramName) {
        if (variableParamValueTable.containsKey(paramName)) {
            return variableParamValueTable.get(paramName).get();
        }
        return null;
    }

    private IoTDBStartCheck() {
        logger.info("Starting IoTDB {}", (Object)IoTDBConstant.VERSION_WITH_BUILD);
        File dir = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR);
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                logger.error("Can not create schema dir: {}", (Object)SCHEMA_DIR);
                System.exit(-1);
            } else {
                logger.info(" {} dir has been created.", (Object)SCHEMA_DIR);
            }
        }
        this.oldPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME);
        this.propertiesFile = SystemFileFactory.INSTANCE.getFile(config.getSystemDir() + File.separator + PROPERTIES_FILE_NAME);
        this.tmpPropertiesFile = SystemFileFactory.INSTANCE.getFile(SCHEMA_DIR + File.separator + PROPERTIES_FILE_NAME + ".tmp");
        this.systemProperties.put(IOTDB_VERSION_STRING, () -> IoTDBConstant.VERSION);
        this.systemProperties.put(COMMIT_ID_STRING, () -> IoTDBConstant.BUILD_INFO);
        for (String param : variableParamValueTable.keySet()) {
            this.systemProperties.put(param, () -> this.getVal(param));
        }
    }

    public boolean checkIsFirstStart() throws IOException {
        if (!this.propertiesFile.exists() && !this.tmpPropertiesFile.exists()) {
            if (this.propertiesFile.createNewFile()) {
                logger.info(" {} has been created.", (Object)this.propertiesFile.getAbsolutePath());
            } else {
                logger.error("can not create {}", (Object)this.propertiesFile.getAbsolutePath());
                System.exit(-1);
            }
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            this.isFirstStart = true;
            return true;
        }
        if (!this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
            logger.info("rename {} to {}", (Object)this.tmpPropertiesFile, (Object)this.propertiesFile);
            this.isFirstStart = false;
            return false;
        }
        if (this.propertiesFile.exists() && this.tmpPropertiesFile.exists()) {
            FileUtils.forceDelete((File)this.tmpPropertiesFile);
            logger.info("remove {}", (Object)this.tmpPropertiesFile);
        }
        this.isFirstStart = false;
        return false;
    }

    public void checkDirectory() throws ConfigurationException, IOException {
        for (String dataDir : config.getLocalDataDirs()) {
            DirectoryChecker.getInstance().registerDirectory(new File(dataDir));
        }
        if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && DirectoryChecker.getInstance().isCrossDisk(config.getDataDirs())) {
            throw new ConfigurationException("Configuring the data directories as cross-disk directories is not supported under RatisConsensus(it will be supported in a later version).");
        }
        DirectoryChecker.getInstance().registerDirectory(new File(config.getSystemDir()));
        if (!(config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") || config.getWalMode().equals((Object)WALMode.DISABLE))) {
            for (String walDir : commonConfig.getWalDirs()) {
                DirectoryChecker.getInstance().registerDirectory(new File(walDir));
            }
        }
        if (config.isClusterMode()) {
            DirectoryChecker.getInstance().registerDirectory(new File(config.getConsensusDir()));
        }
    }

    public void checkOldSystemConfig() throws IOException {
        if (this.oldPropertiesFile.exists()) {
            FileUtils.moveFile((File)this.oldPropertiesFile, (File)this.propertiesFile);
        }
    }

    public void checkSystemConfig() throws ConfigurationException, IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
        if (this.isFirstStart) {
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
            if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.iot.IoTConsensus") && config.getWalMode().equals((Object)WALMode.DISABLE)) {
                throw new ConfigurationException("Configuring the WALMode as disable is not supported under IoTConsensus");
            }
        } else {
            String versionString;
            if (!this.properties.containsKey(IOTDB_VERSION_STRING)) {
                logger.error("DO NOT UPGRADE IoTDB from v0.9 or lower version to v1.0! Please upgrade to v0.10 first");
                System.exit(-1);
            }
            if ((versionString = this.properties.getProperty(IOTDB_VERSION_STRING)).startsWith("0.")) {
                logger.error("IoTDB version is too old");
                System.exit(-1);
            }
            this.checkImmutableSystemProperties();
        }
    }

    private void upgradePropertiesFileFromBrokenFile() throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.systemProperties.forEach((k, v) -> {
                if (!this.properties.containsKey(k)) {
                    this.properties.setProperty((String)k, (String)v.get());
                }
            });
            this.properties.setProperty(IOTDB_VERSION_STRING, IoTDBConstant.VERSION);
            this.properties.setProperty(COMMIT_ID_STRING, IoTDBConstant.BUILD_INFO);
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    private void checkImmutableSystemProperties() throws IOException {
        for (Map.Entry<String, Supplier<String>> entry : this.systemProperties.entrySet()) {
            if (this.properties.containsKey(entry.getKey())) continue;
            this.upgradePropertiesFileFromBrokenFile();
            logger.info("repair system.properties, lack {}", (Object)entry.getKey());
        }
        if (this.properties.containsKey("cluster_name")) {
            config.setClusterName(this.properties.getProperty("cluster_name"));
        }
        if (this.properties.containsKey(DATA_NODE_ID)) {
            config.setDataNodeId(Integer.parseInt(this.properties.getProperty(DATA_NODE_ID)));
        }
        if (this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL)) {
            config.setSchemaRegionConsensusProtocolClass(this.properties.getProperty(SCHEMA_REGION_CONSENSUS_PROTOCOL));
        }
        if (this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL)) {
            config.setDataRegionConsensusProtocolClass(this.properties.getProperty(DATA_REGION_CONSENSUS_PROTOCOL));
        }
    }

    private void throwException(String parameter, Object badValue) throws ConfigurationException {
        throw new ConfigurationException(parameter, String.valueOf(badValue), this.properties.getProperty(parameter), parameter + "can't be modified after first startup");
    }

    private void reloadProperties() throws IOException {
        try (FileInputStream inputStream = new FileInputStream(this.propertiesFile);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, TSFileConfig.STRING_CHARSET);){
            this.properties.load(inputStreamReader);
        }
    }

    public void serializeClusterNameAndDataNodeId(String clusterName, int dataNodeId) throws IOException {
        if (this.tmpPropertiesFile.createNewFile()) {
            logger.info("Create system.properties.tmp {}.", (Object)this.tmpPropertiesFile);
        } else {
            logger.error("Create system.properties.tmp {} failed.", (Object)this.tmpPropertiesFile);
            System.exit(-1);
        }
        this.reloadProperties();
        try (FileOutputStream tmpFOS = new FileOutputStream(this.tmpPropertiesFile.toString());){
            this.properties.setProperty("cluster_name", clusterName);
            this.properties.setProperty(DATA_NODE_ID, String.valueOf(dataNodeId));
            this.properties.store(tmpFOS, SYSTEM_PROPERTIES_STRING);
            if (this.propertiesFile.exists()) {
                Files.delete(this.propertiesFile.toPath());
            }
        }
        FileUtils.moveFile((File)this.tmpPropertiesFile, (File)this.propertiesFile);
    }

    public boolean checkConsensusProtocolExists(TConsensusGroupType type) {
        if (type == TConsensusGroupType.DataRegion) {
            return this.properties.containsKey(DATA_REGION_CONSENSUS_PROTOCOL);
        }
        if (type == TConsensusGroupType.SchemaRegion) {
            return this.properties.containsKey(SCHEMA_REGION_CONSENSUS_PROTOCOL);
        }
        logger.error("Unexpected consensus group type");
        return false;
    }

    public void serializeMutableSystemPropertiesIfNecessary() throws IOException {
        boolean needsSerialize = false;
        for (String param : variableParamValueTable.keySet()) {
            if (this.properties.getProperty(param).equals(this.getVal(param))) continue;
            needsSerialize = true;
        }
        if (needsSerialize) {
            try (FileOutputStream outputStream = new FileOutputStream(this.propertiesFile);){
                this.systemProperties.forEach((k, v) -> this.properties.setProperty((String)k, (String)v.get()));
                this.properties.store(outputStream, SYSTEM_PROPERTIES_STRING);
            }
        }
    }

    static {
        variableParamValueTable.put(INTERNAL_ADDRESS, () -> String.valueOf(config.getInternalAddress()));
        variableParamValueTable.put(INTERNAL_PORT, () -> String.valueOf(config.getInternalPort()));
        variableParamValueTable.put(RPC_ADDRESS, () -> String.valueOf(config.getRpcAddress()));
        variableParamValueTable.put(RPC_PORT, () -> String.valueOf(config.getRpcPort()));
        variableParamValueTable.put(MPP_DATA_EXCHANGE_PORT, () -> String.valueOf(config.getMppDataExchangePort()));
        variableParamValueTable.put(SCHEMA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getSchemaRegionConsensusPort()));
        variableParamValueTable.put(DATA_REGION_CONSENSUS_PORT, () -> String.valueOf(config.getDataRegionConsensusPort()));
    }

    private static class IoTDBConfigCheckHolder {
        private static final IoTDBStartCheck INSTANCE = new IoTDBStartCheck();

        private IoTDBConfigCheckHolder() {
        }
    }
}

