/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.runtime;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMetaSyncProcedure
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeMetaSyncProcedure.class);

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.SYNC_PIPE_META;
    }

    @Override
    protected void executeFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: executeFromValidateTask");
    }

    @Override
    protected void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: executeFromCalculateInfoForTask");
    }

    @Override
    protected void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: executeFromWriteConfigNodeConsensus");
    }

    @Override
    protected void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("PipeMetaSyncProcedure: executeFromOperateOnDataNodes");
        Map<Integer, TPushPipeMetaResp> respMap = this.pushPipeMetaToDataNodes(env);
        if (((PipeTaskInfo)this.pipeTaskInfo.get()).recordPushPipeMetaExceptions(respMap)) {
            throw new PipeException(String.format("Failed to push pipe meta to dataNodes, details: %s", this.parsePushPipeMetaExceptionForPipe(null, respMap)));
        }
    }

    @Override
    protected void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: rollbackFromValidateTask");
    }

    @Override
    protected void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: rollbackFromCalculateInfoForTask");
    }

    @Override
    protected void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: rollbackFromWriteConfigNodeConsensus");
    }

    @Override
    protected void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("PipeMetaSyncProcedure: rollbackFromOperateOnDataNodes");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.PIPE_META_SYNC_PROCEDURE.getTypeCode());
        super.serialize(stream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof PipeMetaSyncProcedure;
    }

    public int hashCode() {
        return 0;
    }
}

