/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.quota;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetSpaceQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetThrottleQuotaPlan;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaInfo
implements SnapshotProcessor {
    private static final Logger logger = LoggerFactory.getLogger(QuotaInfo.class);
    private final ReentrantReadWriteLock spaceQuotaReadWriteLock = new ReentrantReadWriteLock();
    private final Map<String, TSpaceQuota> spaceQuotaLimit = new HashMap<String, TSpaceQuota>();
    private final Map<String, TSpaceQuota> spaceQuotaUsage = new HashMap<String, TSpaceQuota>();
    private final Map<String, TThrottleQuota> throttleQuotaLimit = new HashMap<String, TThrottleQuota>();
    private final String snapshotFileName = "quota_info.bin";

    public TSStatus setSpaceQuota(SetSpaceQuotaPlan setSpaceQuotaPlan) {
        for (String database : setSpaceQuotaPlan.getPrefixPathList()) {
            TSpaceQuota spaceQuota = setSpaceQuotaPlan.getSpaceLimit();
            if (this.spaceQuotaLimit.containsKey(database)) {
                if (spaceQuota.getDeviceNum() == 0L) {
                    spaceQuota.setDeviceNum(this.spaceQuotaLimit.get(database).getDeviceNum());
                }
                if (spaceQuota.getTimeserieNum() == 0L) {
                    spaceQuota.setTimeserieNum(this.spaceQuotaLimit.get(database).getTimeserieNum());
                }
                if (spaceQuota.getDiskSize() == 0L) {
                    spaceQuota.setDiskSize(this.spaceQuotaLimit.get(database).getDiskSize());
                }
                if (spaceQuota.getDeviceNum() == -1L) {
                    spaceQuota.setDeviceNum(0L);
                }
                if (spaceQuota.getTimeserieNum() == -1L) {
                    spaceQuota.setTimeserieNum(0L);
                }
                if (spaceQuota.getDiskSize() == -1L) {
                    spaceQuota.setDiskSize(0L);
                }
            }
            if (!this.spaceQuotaUsage.containsKey(database)) {
                this.spaceQuotaUsage.put(database, new TSpaceQuota());
            }
            this.spaceQuotaLimit.put(database, spaceQuota);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus setThrottleQuota(SetThrottleQuotaPlan setThrottleQuotaPlan) {
        TThrottleQuota throttleQuota = setThrottleQuotaPlan.getThrottleQuota();
        String userName = setThrottleQuotaPlan.getUserName();
        if (this.throttleQuotaLimit.containsKey(setThrottleQuotaPlan.getUserName())) {
            if (setThrottleQuotaPlan.getThrottleQuota().getMemLimit() == -1L) {
                this.throttleQuotaLimit.get(userName).setMemLimit(0L);
            } else if (setThrottleQuotaPlan.getThrottleQuota().getMemLimit() != 0L) {
                this.throttleQuotaLimit.get(userName).setMemLimit(throttleQuota.getMemLimit());
            }
            if (setThrottleQuotaPlan.getThrottleQuota().getCpuLimit() == -1) {
                this.throttleQuotaLimit.get(userName).setCpuLimit(0);
            } else if (setThrottleQuotaPlan.getThrottleQuota().getCpuLimit() != 0) {
                this.throttleQuotaLimit.get(userName).setCpuLimit(throttleQuota.getCpuLimit());
            }
            if (!throttleQuota.getThrottleLimit().isEmpty()) {
                for (ThrottleType throttleType : throttleQuota.getThrottleLimit().keySet()) {
                    if (this.throttleQuotaLimit.get(userName).getThrottleLimit().containsKey(throttleType)) {
                        ((TTimedQuota)this.throttleQuotaLimit.get(userName).getThrottleLimit().get(throttleType)).setSoftLimit(((TTimedQuota)throttleQuota.getThrottleLimit().get(throttleType)).getSoftLimit());
                        ((TTimedQuota)this.throttleQuotaLimit.get(userName).getThrottleLimit().get(throttleType)).setTimeUnit(((TTimedQuota)throttleQuota.getThrottleLimit().get(throttleType)).getTimeUnit());
                        continue;
                    }
                    this.throttleQuotaLimit.get(userName).getThrottleLimit().put(throttleType, (TTimedQuota)throttleQuota.getThrottleLimit().get(throttleType));
                }
            }
        } else {
            this.throttleQuotaLimit.put(setThrottleQuotaPlan.getUserName(), setThrottleQuotaPlan.getThrottleQuota());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public Map<String, TSpaceQuota> getSpaceQuotaLimit() {
        return this.spaceQuotaLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "quota_info.bin");
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            logger.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.spaceQuotaReadWriteLock.writeLock().lock();
        try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
            this.serializeSpaceQuotaLimit(fileOutputStream);
            this.serializeThrottleQuotaLimit(fileOutputStream);
        }
        finally {
            this.spaceQuotaReadWriteLock.writeLock().unlock();
        }
        return true;
    }

    private void serializeSpaceQuotaLimit(FileOutputStream fileOutputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.spaceQuotaLimit.size(), (OutputStream)fileOutputStream);
        for (Map.Entry<String, TSpaceQuota> spaceQuotaEntry : this.spaceQuotaLimit.entrySet()) {
            ReadWriteIOUtils.write((String)spaceQuotaEntry.getKey(), (OutputStream)fileOutputStream);
            ReadWriteIOUtils.write((long)spaceQuotaEntry.getValue().getDeviceNum(), (OutputStream)fileOutputStream);
            ReadWriteIOUtils.write((long)spaceQuotaEntry.getValue().getTimeserieNum(), (OutputStream)fileOutputStream);
            ReadWriteIOUtils.write((long)spaceQuotaEntry.getValue().getDiskSize(), (OutputStream)fileOutputStream);
        }
    }

    private void serializeThrottleQuotaLimit(FileOutputStream fileOutputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.throttleQuotaLimit.size(), (OutputStream)fileOutputStream);
        for (Map.Entry<String, TThrottleQuota> throttleQuotaEntry : this.throttleQuotaLimit.entrySet()) {
            ReadWriteIOUtils.write((String)throttleQuotaEntry.getKey(), (OutputStream)fileOutputStream);
            TThrottleQuota throttleQuota = throttleQuotaEntry.getValue();
            ReadWriteIOUtils.write((int)throttleQuota.getThrottleLimit().size(), (OutputStream)fileOutputStream);
            for (Map.Entry entry : throttleQuota.getThrottleLimit().entrySet()) {
                ReadWriteIOUtils.write((String)((ThrottleType)entry.getKey()).name(), (OutputStream)fileOutputStream);
                ReadWriteIOUtils.write((long)((TTimedQuota)entry.getValue()).getTimeUnit(), (OutputStream)fileOutputStream);
                ReadWriteIOUtils.write((long)((TTimedQuota)entry.getValue()).getSoftLimit(), (OutputStream)fileOutputStream);
            }
            ReadWriteIOUtils.write((long)throttleQuota.getMemLimit(), (OutputStream)fileOutputStream);
            ReadWriteIOUtils.write((int)throttleQuota.getCpuLimit(), (OutputStream)fileOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, "quota_info.bin");
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            logger.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.spaceQuotaReadWriteLock.writeLock().lock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.clear();
            this.deserializeSpaceQuotaLimit(fileInputStream);
            this.deserializeThrottleQuotaLimit(fileInputStream);
        }
        finally {
            this.spaceQuotaReadWriteLock.writeLock().unlock();
        }
    }

    private void deserializeSpaceQuotaLimit(FileInputStream fileInputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)fileInputStream); size > 0; --size) {
            String path = ReadWriteIOUtils.readString((InputStream)fileInputStream);
            TSpaceQuota spaceQuota = new TSpaceQuota();
            spaceQuota.setDeviceNum(ReadWriteIOUtils.readLong((InputStream)fileInputStream));
            spaceQuota.setTimeserieNum(ReadWriteIOUtils.readLong((InputStream)fileInputStream));
            spaceQuota.setDiskSize(ReadWriteIOUtils.readLong((InputStream)fileInputStream));
            this.spaceQuotaLimit.put(path, spaceQuota);
            this.spaceQuotaUsage.put(path, new TSpaceQuota());
        }
    }

    private void deserializeThrottleQuotaLimit(FileInputStream fileInputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)fileInputStream); size > 0; --size) {
            String userName = ReadWriteIOUtils.readString((InputStream)fileInputStream);
            HashMap<ThrottleType, TTimedQuota> quotaLimit = new HashMap<ThrottleType, TTimedQuota>();
            TThrottleQuota throttleQuota = new TThrottleQuota();
            for (int quotaSize = ReadWriteIOUtils.readInt((InputStream)fileInputStream); quotaSize > 0; --quotaSize) {
                ThrottleType throttleType = ThrottleType.valueOf((String)ReadWriteIOUtils.readString((InputStream)fileInputStream));
                long timeUnit = ReadWriteIOUtils.readLong((InputStream)fileInputStream);
                long softLimit = ReadWriteIOUtils.readLong((InputStream)fileInputStream);
                quotaLimit.put(throttleType, new TTimedQuota(timeUnit, softLimit));
            }
            throttleQuota.setThrottleLimit(quotaLimit);
            throttleQuota.setMemLimit(ReadWriteIOUtils.readLong((InputStream)fileInputStream));
            throttleQuota.setCpuLimit(ReadWriteIOUtils.readInt((InputStream)fileInputStream));
            this.throttleQuotaLimit.put(userName, throttleQuota);
        }
    }

    public Map<String, TSpaceQuota> getSpaceQuotaUsage() {
        return this.spaceQuotaUsage;
    }

    public Map<String, TThrottleQuota> getThrottleQuotaLimit() {
        return this.throttleQuotaLimit;
    }

    public void clear() {
        this.spaceQuotaLimit.clear();
        this.throttleQuotaLimit.clear();
    }
}

