/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.executable.ExecutableManager;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.TriggerTable;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerJarPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.read.trigger.GetTriggerTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.AddTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerLocationPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggersOnTransferNodesPlan;
import org.apache.iotdb.confignode.consensus.response.JarResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TransferringTriggersResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerLocationResp;
import org.apache.iotdb.confignode.consensus.response.trigger.TriggerTableResp;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerInfo.class);
    private static final ConfigNodeConfig CONFIG_NODE_CONF = ConfigNodeDescriptor.getInstance().getConf();
    private final TriggerTable triggerTable;
    private final Map<String, String> existedJarToMD5;
    private final TriggerExecutableManager triggerExecutableManager;
    private final ReentrantLock triggerTableLock = new ReentrantLock();
    private static final String SNAPSHOT_FILENAME = "trigger_info.bin";

    public TriggerInfo() throws IOException {
        this.triggerTable = new TriggerTable();
        this.existedJarToMD5 = new HashMap<String, String>();
        this.triggerExecutableManager = TriggerExecutableManager.setupAndGetInstance((String)CONFIG_NODE_CONF.getTriggerTemporaryLibDir(), (String)CONFIG_NODE_CONF.getTriggerDir());
    }

    public void acquireTriggerTableLock() {
        LOGGER.info("acquire TriggerTableLock");
        this.triggerTableLock.lock();
    }

    public void releaseTriggerTableLock() {
        LOGGER.info("release TriggerTableLock");
        this.triggerTableLock.unlock();
    }

    public void validate(String triggerName, String jarName, String jarMD5) throws TriggerManagementException {
        if (this.triggerTable.containsTrigger(triggerName)) {
            throw new TriggerManagementException(String.format("Failed to create trigger [%s], the same name trigger has been created", triggerName));
        }
        if (this.existedJarToMD5.containsKey(jarName) && !this.existedJarToMD5.get(jarName).equals(jarMD5)) {
            throw new TriggerManagementException(String.format("Failed to create trigger [%s], the same name Jar [%s] but different MD5 [%s] has existed", triggerName, jarName, jarMD5));
        }
    }

    public void validate(String triggerName) throws TriggerManagementException {
        if (this.triggerTable.containsTrigger(triggerName)) {
            return;
        }
        throw new TriggerManagementException(String.format("Failed to drop trigger [%s], this trigger has not been created", triggerName));
    }

    public boolean needToSaveJar(String jarName) {
        return !this.existedJarToMD5.containsKey(jarName);
    }

    public TSStatus addTriggerInTable(AddTriggerInTablePlan physicalPlan) {
        try {
            TriggerInformation triggerInformation = physicalPlan.getTriggerInformation();
            this.triggerTable.addTriggerInformation(triggerInformation.getTriggerName(), triggerInformation);
            if (triggerInformation.isUsingURI()) {
                this.existedJarToMD5.put(triggerInformation.getJarName(), triggerInformation.getJarFileMD5());
                if (physicalPlan.getJarFile() != null) {
                    this.triggerExecutableManager.saveToInstallDir(ByteBuffer.wrap(physicalPlan.getJarFile().getValues()), triggerInformation.getJarName());
                }
            }
            return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to add trigger [%s] in TriggerTable on Config Nodes, because of %s", physicalPlan.getTriggerInformation().getTriggerName(), e);
            LOGGER.warn(errorMessage, (Throwable)e);
            return new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(errorMessage);
        }
    }

    public TSStatus deleteTriggerInTable(DeleteTriggerInTablePlan physicalPlan) {
        String triggerName = physicalPlan.getTriggerName();
        if (this.triggerTable.containsTrigger(triggerName)) {
            this.existedJarToMD5.remove(this.triggerTable.getTriggerInformation(triggerName).getJarName());
            this.triggerTable.deleteTriggerInformation(triggerName);
        }
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus updateTriggerStateInTable(UpdateTriggerStateInTablePlan physicalPlan) {
        this.triggerTable.setTriggerState(physicalPlan.getTriggerName(), physicalPlan.getTriggerState());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TriggerTableResp getTriggerTable(GetTriggerTablePlan req) {
        if (req.isOnlyStateful()) {
            return new TriggerTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.triggerTable.getAllStatefulTriggerInformation());
        }
        return new TriggerTableResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), this.triggerTable.getAllTriggerInformation());
    }

    public DataSet getTriggerLocation(GetTriggerLocationPlan req) {
        TDataNodeLocation dataNodeLocation = this.triggerTable.getTriggerLocation(req.getTriggerName());
        if (dataNodeLocation != null) {
            return new TriggerLocationResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), dataNodeLocation);
        }
        return new TriggerLocationResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage(String.format("Fail to get Location trigger[%s]", req.getTriggerName())), null);
    }

    public JarResp getTriggerJar(GetTriggerJarPlan physicalPlan) {
        ArrayList<ByteBuffer> jarList = new ArrayList<ByteBuffer>();
        try {
            for (String jarName : physicalPlan.getJarNames()) {
                jarList.add(ExecutableManager.transferToBytebuffer((String)TriggerExecutableManager.getInstance().getFileStringUnderInstallByName(jarName)));
            }
        }
        catch (Exception e) {
            LOGGER.error("Get TriggerJar failed", (Throwable)e);
            return new JarResp(new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode()).setMessage("Get TriggerJar failed, because " + e.getMessage()), Collections.emptyList());
        }
        return new JarResp(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()), jarList);
    }

    public TransferringTriggersResp getTransferringTriggers() {
        return new TransferringTriggersResp(this.triggerTable.getTransferringTriggers());
    }

    public TSStatus updateTriggersOnTransferNodes(UpdateTriggersOnTransferNodesPlan physicalPlan) {
        this.triggerTable.updateTriggersOnTransferNodes(physicalPlan.getDataNodeLocations());
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public TSStatus updateTriggerLocation(UpdateTriggerLocationPlan physicalPlan) {
        this.triggerTable.updateTriggerLocation(physicalPlan.getTriggerName(), physicalPlan.getDataNodeLocation());
        this.triggerTable.setTriggerState(physicalPlan.getTriggerName(), TTriggerState.ACTIVE);
        return new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode());
    }

    public Map<String, TriggerInformation> getRawTriggerTable() {
        return this.triggerTable.getTable();
    }

    public Map<String, String> getRawExistedJarToMD5() {
        return this.existedJarToMD5;
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (snapshotFile.exists() && snapshotFile.isFile()) {
            LOGGER.error("Failed to take snapshot, because snapshot file [{}] is already exist.", (Object)snapshotFile.getAbsolutePath());
            return false;
        }
        this.acquireTriggerTableLock();
        try {
            boolean bl;
            try (FileOutputStream fileOutputStream = new FileOutputStream(snapshotFile);){
                this.serializeExistedJarToMD5(fileOutputStream);
                this.triggerTable.serializeTriggerTable((OutputStream)fileOutputStream);
                bl = true;
            }
            return bl;
        }
        finally {
            this.releaseTriggerTableLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        File snapshotFile = new File(snapshotDir, SNAPSHOT_FILENAME);
        if (!snapshotFile.exists() || !snapshotFile.isFile()) {
            LOGGER.error("Failed to load snapshot,snapshot file [{}] is not exist.", (Object)snapshotFile.getAbsolutePath());
            return;
        }
        this.acquireTriggerTableLock();
        try (FileInputStream fileInputStream = new FileInputStream(snapshotFile);){
            this.clear();
            this.deserializeExistedJarToMD5(fileInputStream);
            this.triggerTable.deserializeTriggerTable((InputStream)fileInputStream);
        }
        finally {
            this.releaseTriggerTableLock();
        }
    }

    public void serializeExistedJarToMD5(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((int)this.existedJarToMD5.size(), (OutputStream)outputStream);
        for (Map.Entry<String, String> entry : this.existedJarToMD5.entrySet()) {
            ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)entry.getValue(), (OutputStream)outputStream);
        }
    }

    public void deserializeExistedJarToMD5(InputStream inputStream) throws IOException {
        for (int size = ReadWriteIOUtils.readInt((InputStream)inputStream); size > 0; --size) {
            this.existedJarToMD5.put(ReadWriteIOUtils.readString((InputStream)inputStream), ReadWriteIOUtils.readString((InputStream)inputStream));
        }
    }

    public void clear() {
        this.existedJarToMD5.clear();
        this.triggerTable.clear();
    }
}

