/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionMetrics.class);
    private final IManager configManager;

    public PartitionMetrics(IManager configManager) {
        this.configManager = configManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindRegionPartitionMetrics(metricService);
        this.bindDataNodePartitionMetrics(metricService);
        this.bindDatabasePartitionMetrics(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindRegionPartitionMetrics(metricService);
        this.unbindDataNodePartitionMetrics(metricService);
        this.unbindDatabasePartitionMetrics(metricService);
    }

    private void bindRegionPartitionMetrics(AbstractMetricService metricService) {
        for (RegionStatus status : RegionStatus.values()) {
            metricService.createAutoGauge(Metric.REGION_NUM.toString(), MetricLevel.CORE, (Object)this.getLoadManager(), loadManager -> loadManager.countRegionWithSpecifiedStatus(TConsensusGroupType.SchemaRegion, status), new String[]{Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
            metricService.createAutoGauge(Metric.REGION_NUM.toString(), MetricLevel.CORE, (Object)this.getLoadManager(), loadManager -> loadManager.countRegionWithSpecifiedStatus(TConsensusGroupType.DataRegion, status), new String[]{Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    private void unbindRegionPartitionMetrics(AbstractMetricService metricService) {
        for (RegionStatus status : RegionStatus.values()) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM.toString(), new String[]{Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM.toString(), new String[]{Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    public static void bindDataNodePartitionMetrics(AbstractMetricService metricService, IManager configManager, int dataNodeId) {
        NodeManager nodeManager = configManager.getNodeManager();
        PartitionManager partitionManager = configManager.getPartitionManager();
        LoadManager loadManager = configManager.getLoadManager();
        String dataNodeName = NodeUrlUtils.convertTEndPointUrl((TEndPoint)nodeManager.getRegisteredDataNode(dataNodeId).getLocation().getClientRpcEndPoint());
        metricService.createAutoGauge(Metric.REGION_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.getRegionCount(dataNodeId, TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.getRegionCount(dataNodeId, TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)loadManager, obj -> obj.getRegionGroupLeaderCount(dataNodeId, TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)loadManager, obj -> obj.getRegionGroupLeaderCount(dataNodeId, TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    private void bindDataNodePartitionMetrics(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> registerDataNodes = this.getNodeManager().getRegisteredDataNodes();
        for (TDataNodeConfiguration dataNodeConfiguration : registerDataNodes) {
            int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
            PartitionMetrics.bindDataNodePartitionMetrics(metricService, this.configManager, dataNodeId);
        }
    }

    public static void unbindDataNodePartitionMetrics(AbstractMetricService metricService, String dataNodeName) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    private void unbindDataNodePartitionMetrics(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> registerDataNodes = this.getNodeManager().getRegisteredDataNodes();
        for (TDataNodeConfiguration dataNodeConfiguration : registerDataNodes) {
            String dataNodeName = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeConfiguration.getLocation().getClientRpcEndPoint());
            PartitionMetrics.unbindDataNodePartitionMetrics(metricService, dataNodeName);
        }
    }

    public static void bindDatabasePartitionMetrics(AbstractMetricService metricService, IManager configManager, String database) {
        PartitionManager partitionManager = configManager.getPartitionManager();
        metricService.createAutoGauge(Metric.SERIES_SLOT_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> manager.getAssignedSeriesPartitionSlotsCount(database), new String[]{Tag.NAME.toString(), database});
        metricService.createAutoGauge(Metric.TIME_SLOT_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> manager.getAssignedTimePartitionSlotsCount(database), new String[]{Tag.NAME.toString(), database});
        metricService.createAutoGauge(Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> {
            try {
                return manager.getRegionGroupCount(database, TConsensusGroupType.SchemaRegion);
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("Error when counting SchemaRegionGroups in Database: {}", (Object)database, (Object)e);
                return -1.0;
            }
        }, new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> {
            try {
                return manager.getRegionGroupCount(database, TConsensusGroupType.DataRegion);
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.warn("Error when counting DataRegionGroups in Database: {}", (Object)database, (Object)e);
                return -1.0;
            }
        }, new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    private void bindDatabasePartitionMetrics(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.DATABASE_NUM.toString(), MetricLevel.CORE, (Object)this.getClusterSchemaManager(), clusterSchemaManager -> clusterSchemaManager.getDatabaseNames().size(), new String[0]);
        List<String> databases = this.getClusterSchemaManager().getDatabaseNames();
        for (String database : databases) {
            PartitionMetrics.bindDatabasePartitionMetrics(metricService, this.configManager, database);
        }
    }

    public static void unbindDatabasePartitionMetrics(AbstractMetricService metricService, String database) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SERIES_SLOT_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.TIME_SLOT_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    private void unbindDatabasePartitionMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATABASE_NUM.toString(), new String[0]);
        List<String> databases = this.getClusterSchemaManager().getDatabaseNames();
        for (String database : databases) {
            PartitionMetrics.unbindDatabasePartitionMetrics(metricService, database);
        }
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionMetrics that = (PartitionMetrics)o;
        return this.configManager.equals(that.configManager);
    }

    public int hashCode() {
        return Objects.hash(this.configManager);
    }
}

