/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.consensus;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.conf.SystemPropertiesUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.statemachine.ConfigRegionStateMachine;
import org.apache.iotdb.confignode.exception.AddPeerException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsensusManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsensusManager.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final CommonConfig COMMON_CONF = CommonDescriptor.getInstance().getConfig();
    private static final int SEED_CONFIG_NODE_ID = 0;
    public static final ConsensusGroupId DEFAULT_CONSENSUS_GROUP_ID = new ConfigRegionId(CONF.getConfigRegionId());
    private final IManager configManager;
    private IConsensus consensusImpl;

    public ConsensusManager(IManager configManager, ConfigRegionStateMachine stateMachine) throws IOException {
        this.configManager = configManager;
        this.setConsensusLayer(stateMachine);
    }

    public void close() throws IOException {
        this.consensusImpl.stop();
    }

    private void setConsensusLayer(ConfigRegionStateMachine stateMachine) throws IOException {
        if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
            this.upgrade();
            this.consensusImpl = (IConsensus)ConsensusFactory.getConsensusImpl((String)"org.apache.iotdb.consensus.simple.SimpleConsensus", (ConsensusConfig)ConsensusConfig.newBuilder().setThisNode(new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())).setStorageDir(CONF.getConsensusDir()).setConsensusGroupType(TConsensusGroupType.ConfigRegion).build(), gid -> stateMachine).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", "org.apache.iotdb.consensus.simple.SimpleConsensus")));
        } else {
            this.consensusImpl = (IConsensus)ConsensusFactory.getConsensusImpl((String)CONF.getConfigNodeConsensusProtocolClass(), (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(CONF.getConfigNodeId()).setThisNode(new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort())).setConsensusGroupType(TConsensusGroupType.ConfigRegion).setRatisConfig(RatisConfig.newBuilder().setLeaderLogAppender(RatisConfig.LeaderLogAppender.newBuilder().setBufferByteLimit(CONF.getConfigNodeRatisConsensusLogAppenderBufferSize()).build()).setSnapshot(RatisConfig.Snapshot.newBuilder().setAutoTriggerThreshold(CONF.getConfigNodeRatisSnapshotTriggerThreshold()).build()).setLog(RatisConfig.Log.newBuilder().setUnsafeFlushEnabled(CONF.isConfigNodeRatisLogUnsafeFlushEnable()).setForceSyncNum(CONF.getConfigNodeRatisLogForceSyncNum()).setSegmentCacheSizeMax(SizeInBytes.valueOf((long)CONF.getConfigNodeRatisLogSegmentSizeMax())).setPreserveNumsWhenPurge(CONF.getConfigNodeRatisPreserveLogsWhenPurge()).build()).setGrpc(RatisConfig.Grpc.newBuilder().setFlowControlWindow(SizeInBytes.valueOf((long)CONF.getConfigNodeRatisGrpcFlowControlWindow())).setLeaderOutstandingAppendsMax(CONF.getConfigNodeRatisGrpcLeaderOutstandingAppendsMax()).build()).setRpc(RatisConfig.Rpc.newBuilder().setTimeoutMin(TimeDuration.valueOf((long)CONF.getConfigNodeRatisRpcLeaderElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setTimeoutMax(TimeDuration.valueOf((long)CONF.getConfigNodeRatisRpcLeaderElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setRequestTimeout(TimeDuration.valueOf((long)CONF.getConfigNodeRatisRequestTimeoutMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMin(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMinMs(), (TimeUnit)TimeUnit.MILLISECONDS)).setFirstElectionTimeoutMax(TimeDuration.valueOf((long)CONF.getRatisFirstElectionTimeoutMaxMs(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).setClient(RatisConfig.Client.newBuilder().setClientRequestTimeoutMillis(CONF.getConfigNodeRatisRequestTimeoutMs()).setClientMaxRetryAttempt(CONF.getConfigNodeRatisMaxRetryAttempts()).setClientRetryInitialSleepTimeMs(CONF.getConfigNodeRatisInitialSleepTimeMs()).setClientRetryMaxSleepTimeMs(CONF.getConfigNodeRatisMaxSleepTimeMs()).setCoreClientNumForEachNode(CONF.getCoreClientNumForEachNode()).setMaxClientNumForEachNode(CONF.getMaxClientNumForEachNode()).build()).setImpl(RatisConfig.Impl.newBuilder().setTriggerSnapshotFileSize(CONF.getConfigNodeRatisLogMax()).build()).setRead(RatisConfig.Read.newBuilder().setReadTimeout(TimeDuration.valueOf((long)COMMON_CONF.getConnectionTimeoutInMS(), (TimeUnit)TimeUnit.MILLISECONDS)).build()).build()).setStorageDir(CONF.getConsensusDir()).build(), gid -> stateMachine).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", CONF.getConfigNodeConsensusProtocolClass())));
        }
        this.consensusImpl.start();
        if (SystemPropertiesUtils.isRestarted()) {
            if ("org.apache.iotdb.consensus.simple.SimpleConsensus".equals(CONF.getConfigNodeConsensusProtocolClass())) {
                try {
                    this.createPeerForConsensusGroup(SystemPropertiesUtils.loadConfigNodeList());
                }
                catch (BadNodeUrlException e) {
                    throw new IOException(e);
                }
                catch (ConsensusException e) {
                    LOGGER.error("Something wrong happened while calling consensus layer's createLocalPeer API.", (Throwable)e);
                }
            }
            LOGGER.info("Init ConsensusManager successfully when restarted");
        } else if (ConfigNodeDescriptor.getInstance().isSeedConfigNode()) {
            try {
                this.createPeerForConsensusGroup(Collections.singletonList(new TConfigNodeLocation(0, new TEndPoint(CONF.getInternalAddress(), CONF.getInternalPort()), new TEndPoint(CONF.getInternalAddress(), CONF.getConsensusPort()))));
            }
            catch (ConsensusException e) {
                LOGGER.error("Something wrong happened while calling consensus layer's createLocalPeer API.", (Throwable)e);
            }
        }
    }

    private void upgrade() {
        File oldWalDir;
        File consensusDir = new File(CONF.getConsensusDir());
        if (consensusDir.exists() && (oldWalDir = new File(consensusDir, "simple")).exists() && !oldWalDir.renameTo(new File(ConsensusManager.getConfigRegionDir()))) {
            LOGGER.warn("upgrade ConfigNode consensus wal dir for SimpleConsensus from version/1.0 to version/1.1 failed, you maybe need to rename the simple dir to 0_0 manually.");
        }
    }

    public void createPeerForConsensusGroup(List<TConfigNodeLocation> configNodeLocations) throws ConsensusException {
        LOGGER.info("createPeerForConsensusGroup {}...", configNodeLocations);
        ArrayList<Peer> peerList = new ArrayList<Peer>();
        for (TConfigNodeLocation configNodeLocation : configNodeLocations) {
            peerList.add(new Peer(DEFAULT_CONSENSUS_GROUP_ID, configNodeLocation.getConfigNodeId(), configNodeLocation.getConsensusEndPoint()));
        }
        this.consensusImpl.createLocalPeer(DEFAULT_CONSENSUS_GROUP_ID, peerList);
    }

    public void addConfigNodePeer(TConfigNodeLocation configNodeLocation) throws AddPeerException {
        try {
            this.consensusImpl.addRemotePeer(DEFAULT_CONSENSUS_GROUP_ID, new Peer(DEFAULT_CONSENSUS_GROUP_ID, configNodeLocation.getConfigNodeId(), configNodeLocation.getConsensusEndPoint()));
        }
        catch (ConsensusException e) {
            throw new AddPeerException(configNodeLocation);
        }
    }

    public boolean removeConfigNodePeer(TConfigNodeLocation configNodeLocation) {
        try {
            this.consensusImpl.removeRemotePeer(DEFAULT_CONSENSUS_GROUP_ID, new Peer(DEFAULT_CONSENSUS_GROUP_ID, configNodeLocation.getConfigNodeId(), configNodeLocation.getConsensusEndPoint()));
            return true;
        }
        catch (ConsensusException e) {
            return false;
        }
    }

    public TSStatus write(ConfigPhysicalPlan plan) throws ConsensusException {
        return this.consensusImpl.write(DEFAULT_CONSENSUS_GROUP_ID, (IConsensusRequest)plan);
    }

    public DataSet read(ConfigPhysicalPlan plan) throws ConsensusException {
        return this.consensusImpl.read(DEFAULT_CONSENSUS_GROUP_ID, (IConsensusRequest)plan);
    }

    public boolean isLeader() {
        return this.consensusImpl.isLeader(DEFAULT_CONSENSUS_GROUP_ID);
    }

    public boolean isLeaderReady() {
        return this.consensusImpl.isLeaderReady(DEFAULT_CONSENSUS_GROUP_ID);
    }

    public TConfigNodeLocation getLeader() {
        for (int retry = 0; retry < 50; ++retry) {
            List<TConfigNodeLocation> registeredConfigNodes;
            TConfigNodeLocation leaderLocation;
            Peer leaderPeer = this.consensusImpl.getLeader(DEFAULT_CONSENSUS_GROUP_ID);
            if (leaderPeer != null && (leaderLocation = (TConfigNodeLocation)(registeredConfigNodes = this.getNodeManager().getRegisteredConfigNodes()).stream().filter(leader -> leader.getConfigNodeId() == leaderPeer.getNodeId()).findFirst().orElse(null)) != null) {
                return leaderLocation;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.warn("ConsensusManager getLeader been interrupted, ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    public TSStatus confirmLeader() {
        TSStatus result = new TSStatus();
        if (this.isLeaderReady()) {
            result.setCode(TSStatusCode.SUCCESS_STATUS.getStatusCode());
        } else {
            result.setCode(TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode());
            if (this.isLeader()) {
                result.setMessage("The current ConfigNode is leader but not ready yet, please try again later.");
            } else {
                result.setMessage("The current ConfigNode is not leader, please redirect to a new ConfigNode.");
            }
            TConfigNodeLocation leaderLocation = this.getLeader();
            if (leaderLocation != null) {
                result.setRedirectNode(leaderLocation.getInternalEndPoint());
            }
        }
        return result;
    }

    public ConsensusGroupId getConsensusGroupId() {
        return DEFAULT_CONSENSUS_GROUP_ID;
    }

    public static String getConfigRegionDir() {
        return CONF.getConsensusDir() + File.separator + DEFAULT_CONSENSUS_GROUP_ID.getType().getValue() + "_" + DEFAULT_CONSENSUS_GROUP_ID.getId();
    }

    public IConsensus getConsensusImpl() {
        return this.consensusImpl;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }
}

