/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.ratis;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.pool2.KeyedObjectPool;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.ClientManager;
import org.apache.iotdb.commons.client.ClientManagerMetrics;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.property.ClientPoolProperty;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.service.metric.MetricService;
import org.apache.iotdb.commons.utils.StatusUtils;
import org.apache.iotdb.consensus.IConsensus;
import org.apache.iotdb.consensus.IStateMachine;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.config.RatisConfig;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.consensus.exception.ConsensusGroupAlreadyExistException;
import org.apache.iotdb.consensus.exception.ConsensusGroupNotExistException;
import org.apache.iotdb.consensus.exception.PeerAlreadyInConsensusGroupException;
import org.apache.iotdb.consensus.exception.PeerNotInConsensusGroupException;
import org.apache.iotdb.consensus.exception.RatisRequestFailedException;
import org.apache.iotdb.consensus.exception.RatisUnderRecoveryException;
import org.apache.iotdb.consensus.ratis.ApplicationStateMachineProxy;
import org.apache.iotdb.consensus.ratis.RatisClient;
import org.apache.iotdb.consensus.ratis.RequestMessage;
import org.apache.iotdb.consensus.ratis.ResponseMessage;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricSet;
import org.apache.iotdb.consensus.ratis.metrics.RatisMetricsManager;
import org.apache.iotdb.consensus.ratis.utils.RatisLogMonitor;
import org.apache.iotdb.consensus.ratis.utils.Utils;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.ratis.client.RaftClientRpc;
import org.apache.ratis.conf.Parameters;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.grpc.GrpcFactory;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.exceptions.AlreadyExistsException;
import org.apache.ratis.protocol.exceptions.GroupMismatchException;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.apache.ratis.protocol.exceptions.RaftException;
import org.apache.ratis.protocol.exceptions.ReadException;
import org.apache.ratis.protocol.exceptions.ReadIndexException;
import org.apache.ratis.protocol.exceptions.ResourceUnavailableException;
import org.apache.ratis.server.DivisionInfo;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.util.function.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RatisConsensus
implements IConsensus {
    private static final Logger logger = LoggerFactory.getLogger(RatisConsensus.class);
    private final RaftPeer myself;
    private final RaftServer server;
    private final RaftProperties properties = new RaftProperties();
    private final RaftClientRpc clientRpc;
    private final IClientManager<RaftGroup, RatisClient> clientManager;
    private final Map<RaftGroupId, RaftGroup> lastSeen = new ConcurrentHashMap<RaftGroupId, RaftGroup>();
    private final ClientId localFakeId = ClientId.randomId();
    private final AtomicLong localFakeCallId = new AtomicLong(0L);
    private static final int DEFAULT_PRIORITY = 0;
    private static final int LEADER_PRIORITY = 1;
    private static final int DEFAULT_WAIT_LEADER_READY_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private final ScheduledExecutorService diskGuardian;
    private final long triggerSnapshotThreshold;
    private final RatisConfig config;
    private final RatisLogMonitor monitor = new RatisLogMonitor();
    private final RatisMetricSet ratisMetricSet;
    private final TConsensusGroupType consensusGroupType;
    private final ConcurrentHashMap<ConsensusGroupId, AtomicBoolean> canServeStaleRead = new ConcurrentHashMap();

    public RatisConsensus(ConsensusConfig config, IStateMachine.Registry registry) throws IOException {
        this.myself = Utils.fromNodeInfoAndPriorityToRaftPeer(config.getThisNodeId(), config.getThisNodeEndPoint(), 0);
        RaftServerConfigKeys.setStorageDir((RaftProperties)this.properties, Collections.singletonList(new File(config.getStorageDir())));
        GrpcConfigKeys.Server.setPort((RaftProperties)this.properties, (int)config.getThisNodeEndPoint().getPort());
        Utils.initRatisConfig(this.properties, config.getRatisConfig());
        this.config = config.getRatisConfig();
        this.consensusGroupType = config.getConsensusGroupType();
        this.ratisMetricSet = new RatisMetricSet();
        this.triggerSnapshotThreshold = this.config.getImpl().getTriggerSnapshotFileSize();
        this.diskGuardian = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.RATIS_BG_DISK_GUARDIAN.getName());
        this.clientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new RatisClientPoolFactory());
        this.clientRpc = new GrpcFactory(new Parameters()).newRaftClientRpc(ClientId.randomId(), this.properties);
        this.server = RaftServer.newBuilder().setServerId(this.myself.getId()).setProperties(this.properties).setStateMachineRegistry(raftGroupId -> new ApplicationStateMachineProxy((IStateMachine)registry.apply(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId)), (RaftGroupId)raftGroupId, this.canServeStaleRead)).build();
    }

    @Override
    public synchronized void start() throws IOException {
        MetricService.getInstance().addMetricSet((IMetricSet)this.ratisMetricSet);
        this.server.start();
        this.startSnapshotGuardian();
    }

    @Override
    public synchronized void stop() throws IOException {
        this.diskGuardian.shutdown();
        try {
            this.diskGuardian.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.warn("{}: interrupted when shutting down add Executor with exception {}", (Object)this, (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.clientManager.close();
            this.server.close();
            MetricService.getInstance().removeMetricSet((IMetricSet)this.ratisMetricSet);
        }
    }

    private boolean shouldRetry(RaftClientReply reply) {
        return !reply.isSuccess() && reply.getException() instanceof ResourceUnavailableException;
    }

    private RaftClientReply writeWithRetry(CheckedSupplier<RaftClientReply, IOException> caller) throws IOException {
        int maxRetryTimes = this.config.getImpl().getRetryTimesMax();
        long waitMillis = this.config.getImpl().getRetryWaitMillis();
        int retry = 0;
        RaftClientReply reply = null;
        while (retry < maxRetryTimes) {
            ++retry;
            reply = (RaftClientReply)caller.get();
            if (!this.shouldRetry(reply)) {
                return reply;
            }
            logger.debug("{} sending write request with retry = {} and reply = {}", new Object[]{this, retry, reply});
            try {
                Thread.sleep(waitMillis);
            }
            catch (InterruptedException e) {
                logger.warn("{} retry write sleep is interrupted: {}", (Object)this, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
        if (reply == null) {
            return RaftClientReply.newBuilder().setSuccess(false).setException(new RaftException("null reply received in writeWithRetry for request " + caller)).build();
        }
        return reply;
    }

    private RaftClientReply writeLocallyWithRetry(RaftClientRequest request) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> this.server.submitClientRequest(request)));
    }

    private RaftClientReply writeRemotelyWithRetry(RatisClient client, Message message) throws IOException {
        return this.writeWithRetry((CheckedSupplier<RaftClientReply, IOException>)((CheckedSupplier)() -> client.getRaftClient().io().send(message)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TSStatus write(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        TSStatus writeResult;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = this.getGroupInfo(raftGroupId);
        if (raftGroup == null) throw new ConsensusGroupNotExistException(groupId);
        if (!raftGroup.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        if (this.isLeader(groupId) && Utils.rejectWrite()) {
            try {
                this.forceStepDownLeader(raftGroup);
                return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
            }
            catch (Exception e) {
                logger.warn("leader {} read only, force step down failed due to {}", (Object)this.myself, (Object)e);
            }
            return StatusUtils.getStatus((TSStatusCode)TSStatusCode.SYSTEM_READ_ONLY);
        }
        RequestMessage message = new RequestMessage(request);
        RaftClientRequest clientRequest = this.buildRawRequest(raftGroupId, message, RaftClientRequest.writeRequestType());
        RaftPeer suggestedLeader = null;
        if (this.isLeader(groupId) && this.waitUntilLeaderReady(raftGroupId)) {
            try (RatisMetricsManager.TimeKeeper ignored = RatisMetricsManager.getInstance().startWriteLocallyTimer(this.consensusGroupType);){
                RaftClientReply localServerReply222 = this.writeLocallyWithRetry(clientRequest);
                if (localServerReply222.isSuccess()) {
                    ResponseMessage responseMessage = (ResponseMessage)localServerReply222.getMessage();
                    TSStatus tSStatus = (TSStatus)responseMessage.getContentHolder();
                    return tSStatus;
                }
                NotLeaderException ex = localServerReply222.getNotLeaderException();
                if (ex != null) {
                    suggestedLeader = ex.getSuggestedLeader();
                }
            }
            catch (Exception e) {
                throw new RatisRequestFailedException(e);
            }
        }
        try (RatisMetricsManager.TimeKeeper ignored = RatisMetricsManager.getInstance().startWriteRemotelyTimer(this.consensusGroupType);
             RatisClient client = this.getRaftClient(raftGroup);){
            RaftClientReply reply = this.writeRemotelyWithRetry(client, message);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
            writeResult = Utils.deserializeFrom(reply.getMessage().getContent().asReadOnlyByteBuffer());
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        if (suggestedLeader == null) return writeResult;
        TEndPoint leaderEndPoint = Utils.fromRaftPeerAddressToTEndPoint(suggestedLeader.getAddress());
        writeResult.setRedirectNode(new TEndPoint(leaderEndPoint.getIp(), leaderEndPoint.getPort()));
        return writeResult;
    }

    @Override
    public DataSet read(ConsensusGroupId groupId, IConsensusRequest request) throws ConsensusException {
        RaftClientReply reply;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        boolean isLinearizableRead = !this.canServeStaleRead.computeIfAbsent(groupId, id -> new AtomicBoolean(false)).get();
        try {
            reply = this.doRead(raftGroupId, request, isLinearizableRead);
            if (isLinearizableRead) {
                this.canServeStaleRead.get(groupId).set(true);
            }
        }
        catch (ReadException | ReadIndexException e) {
            if (isLinearizableRead) {
                throw new RatisUnderRecoveryException(e);
            }
            throw new RatisRequestFailedException((Exception)e);
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        Message ret = reply.getMessage();
        ResponseMessage readResponseMessage = (ResponseMessage)ret;
        return (DataSet)readResponseMessage.getContentHolder();
    }

    private RaftClientReply doRead(RaftGroupId gid, IConsensusRequest readRequest, boolean linearizable) throws Exception {
        RaftClientReply reply;
        RaftClientRequest.Type readType = linearizable ? RaftClientRequest.readRequestType() : RaftClientRequest.staleReadRequestType((long)-1L);
        RequestMessage requestMessage = new RequestMessage(readRequest);
        RaftClientRequest request = this.buildRawRequest(gid, requestMessage, readType);
        try (RatisMetricsManager.TimeKeeper ignored = RatisMetricsManager.getInstance().startReadTimer(this.consensusGroupType);){
            reply = this.server.submitClientRequest(request);
        }
        if (!reply.isSuccess()) {
            throw reply.getException();
        }
        return reply;
    }

    @Override
    public void createLocalPeer(ConsensusGroupId groupId, List<Peer> peers) throws ConsensusException {
        RaftGroup group = this.buildRaftGroup(groupId, peers);
        RaftGroup clientGroup = group.getPeers().isEmpty() ? RaftGroup.valueOf((RaftGroupId)group.getGroupId(), (RaftPeer[])new RaftPeer[]{this.myself}) : group;
        try (RatisClient client = this.getRaftClient(clientGroup);){
            RaftClientReply reply = client.getRaftClient().getGroupManagementApi(this.myself.getId()).add(group);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (AlreadyExistsException e) {
            throw new ConsensusGroupAlreadyExistException(groupId);
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
    }

    @Override
    public void deleteLocalPeer(ConsensusGroupId groupId) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            RaftClientReply reply = this.server.groupManagement(GroupManagementRequest.newRemove((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (long)this.localFakeCallId.incrementAndGet(), (RaftGroupId)raftGroupId, (boolean)true, (boolean)false));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (GroupMismatchException e) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        catch (IOException e) {
            throw new RatisRequestFailedException(e);
        }
    }

    @Override
    public void addRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        RaftPeer peerToAdd = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group.getPeers().contains(peerToAdd)) {
            throw new PeerAlreadyInConsensusGroupException(groupId, peer);
        }
        ArrayList<RaftPeer> newConfig = new ArrayList<RaftPeer>(group.getPeers());
        newConfig.add(peerToAdd);
        this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
    }

    @Override
    public void removeRemotePeer(ConsensusGroupId groupId, Peer peer) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup group = this.getGroupInfo(raftGroupId);
        RaftPeer peerToRemove = Utils.fromPeerAndPriorityToRaftPeer(peer, 0);
        if (group == null || !group.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        if (!group.getPeers().contains(peerToRemove)) {
            throw new PeerNotInConsensusGroupException(groupId, this.myself.getAddress());
        }
        List newConfig = group.getPeers().stream().filter(raftPeer -> !raftPeer.equals((Object)peerToRemove)).collect(Collectors.toList());
        this.sendReconfiguration(RaftGroup.valueOf((RaftGroupId)raftGroupId, newConfig));
    }

    @Override
    public void transferLeader(ConsensusGroupId groupId, Peer newLeader) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup raftGroup = Optional.ofNullable(this.getGroupInfo(raftGroupId)).orElseThrow(() -> new ConsensusGroupNotExistException(groupId));
        RaftPeer newRaftLeader = Utils.fromPeerAndPriorityToRaftPeer(newLeader, 1);
        ArrayList<RaftPeer> newConfiguration = new ArrayList<RaftPeer>();
        for (RaftPeer raftPeer : raftGroup.getPeers()) {
            if (raftPeer.getId().equals((Object)newRaftLeader.getId())) {
                newConfiguration.add(newRaftLeader);
                continue;
            }
            newConfiguration.add(Utils.fromNodeInfoAndPriorityToRaftPeer(Utils.fromRaftPeerIdToNodeId(raftPeer.getId()), Utils.fromRaftPeerAddressToTEndPoint(raftPeer.getAddress()), 0));
        }
        try (RatisClient client = this.getRaftClient(raftGroup);){
            RaftClientReply configChangeReply = client.getRaftClient().admin().setConfiguration(newConfiguration);
            if (!configChangeReply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)configChangeReply.getException());
            }
            RaftClientReply reply = this.transferLeader(raftGroup, newRaftLeader);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
    }

    private void forceStepDownLeader(RaftGroup group) throws Exception {
        this.transferLeader(group, null);
    }

    private RaftClientReply transferLeader(RaftGroup group, RaftPeer newLeader) throws Exception {
        try (RatisClient client = this.getRaftClient(group);){
            RaftClientReply raftClientReply = client.getRaftClient().admin().transferLeadership(newLeader != null ? newLeader.getId() : null, 10000L);
            return raftClientReply;
        }
    }

    @Override
    public boolean isLeader(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return this.server.getDivision(raftGroupId).getInfo().isLeader();
        }
        catch (IOException exception) {
            logger.info("isLeader request failed with exception: ", (Throwable)exception);
            return false;
        }
    }

    @Override
    public boolean isLeaderReady(ConsensusGroupId groupId) {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            return this.server.getDivision(raftGroupId).getInfo().isLeaderReady();
        }
        catch (IOException exception) {
            logger.info("isLeaderReady request failed with exception: ", (Throwable)exception);
            return false;
        }
    }

    private boolean waitUntilLeaderReady(RaftGroupId groupId) {
        DivisionInfo divisionInfo;
        try {
            divisionInfo = this.server.getDivision(groupId).getInfo();
        }
        catch (IOException e) {
            logger.info("isLeaderReady checking failed with exception: ", (Throwable)e);
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            while (divisionInfo.isLeader() && !divisionInfo.isLeaderReady()) {
                Thread.sleep(10L);
                long consumedTime = System.currentTimeMillis() - startTime;
                if (consumedTime < (long)DEFAULT_WAIT_LEADER_READY_TIMEOUT) continue;
                logger.warn("{}: leader is still not ready after {}ms", (Object)groupId, (Object)consumedTime);
                return false;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Unexpected interruption when waitUntilLeaderReady", (Throwable)e);
            return false;
        }
        return divisionInfo.isLeader();
    }

    @Override
    public Peer getLeader(ConsensusGroupId groupId) {
        RaftPeerId leaderId;
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        try {
            leaderId = this.server.getDivision(raftGroupId).getInfo().getLeaderId();
        }
        catch (IOException e) {
            logger.warn("fetch division info for group " + groupId + " failed due to: ", (Throwable)e);
            return null;
        }
        if (leaderId == null) {
            return null;
        }
        int nodeId = Utils.fromRaftPeerIdToNodeId(leaderId);
        return new Peer(groupId, nodeId, null);
    }

    @Override
    public List<ConsensusGroupId> getAllConsensusGroupIds() {
        ArrayList<ConsensusGroupId> ids = new ArrayList<ConsensusGroupId>();
        this.server.getGroupIds().forEach(groupId -> ids.add(Utils.fromRaftGroupIdToConsensusGroupId(groupId)));
        return ids;
    }

    @Override
    public void triggerSnapshot(ConsensusGroupId groupId) throws ConsensusException {
        RaftGroupId raftGroupId = Utils.fromConsensusGroupIdToRaftGroupId(groupId);
        RaftGroup groupInfo = this.getGroupInfo(raftGroupId);
        if (groupInfo == null || !groupInfo.getPeers().contains(this.myself)) {
            throw new ConsensusGroupNotExistException(groupId);
        }
        SnapshotManagementRequest request = SnapshotManagementRequest.newCreate((ClientId)this.localFakeId, (RaftPeerId)this.myself.getId(), (RaftGroupId)raftGroupId, (long)this.localFakeCallId.incrementAndGet(), (long)30000L);
        try {
            RaftClientReply reply = this.server.snapshotManagement(request);
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (IOException ioException) {
            throw new RatisRequestFailedException(ioException);
        }
    }

    private void triggerSnapshotByCustomize() {
        for (RaftGroupId raftGroupId : this.server.getGroupIds()) {
            File currentDir;
            try {
                currentDir = this.server.getDivision(raftGroupId).getRaftStorage().getStorageDir().getCurrentDir();
            }
            catch (IOException e) {
                logger.warn("{}: get division {} failed: ", new Object[]{this, raftGroupId, e});
                continue;
            }
            long currentDirLength = this.monitor.updateAndGetDirectorySize(currentDir);
            if (currentDirLength < this.triggerSnapshotThreshold) continue;
            int filesCount = this.monitor.getFilesUnder(currentDir).size();
            logger.info("{}: take snapshot for region {}, current dir size {}, {} files to be purged", new Object[]{this, raftGroupId, currentDirLength, filesCount});
            try {
                this.triggerSnapshot(Utils.fromRaftGroupIdToConsensusGroupId(raftGroupId));
                logger.info("Raft group {} took snapshot successfully", (Object)raftGroupId);
            }
            catch (ConsensusException e) {
                logger.warn("Raft group {} failed to take snapshot due to", (Object)raftGroupId, (Object)e);
            }
        }
    }

    private void startSnapshotGuardian() {
        long delay = this.config.getImpl().getTriggerSnapshotTime();
        ScheduledExecutorUtil.safelyScheduleWithFixedDelay((ScheduledExecutorService)this.diskGuardian, this::triggerSnapshotByCustomize, (long)0L, (long)delay, (TimeUnit)TimeUnit.SECONDS);
    }

    private RaftClientRequest buildRawRequest(RaftGroupId groupId, Message message, RaftClientRequest.Type type) {
        return RaftClientRequest.newBuilder().setServerId(this.server.getId()).setClientId(this.localFakeId).setCallId(this.localFakeCallId.incrementAndGet()).setGroupId(groupId).setType(type).setMessage(message).build();
    }

    private RaftGroup getGroupInfo(RaftGroupId raftGroupId) {
        RaftGroup raftGroup = null;
        try {
            raftGroup = this.server.getDivision(raftGroupId).getGroup();
            RaftGroup lastSeenGroup = this.lastSeen.getOrDefault(raftGroupId, null);
            if (lastSeenGroup != null && !lastSeenGroup.equals((Object)raftGroup)) {
                this.clientManager.clear((Object)lastSeenGroup);
                this.lastSeen.put(raftGroupId, raftGroup);
            }
        }
        catch (IOException e) {
            logger.debug("get group {} failed ", (Object)raftGroupId, (Object)e);
        }
        return raftGroup;
    }

    private RaftGroup buildRaftGroup(ConsensusGroupId groupId, List<Peer> peers) {
        return RaftGroup.valueOf((RaftGroupId)Utils.fromConsensusGroupIdToRaftGroupId(groupId), Utils.fromPeersAndPriorityToRaftPeers(peers, 0));
    }

    private RatisClient getRaftClient(RaftGroup group) throws ClientManagerException {
        try {
            return (RatisClient)this.clientManager.borrowClient((Object)group);
        }
        catch (ClientManagerException e) {
            logger.error(String.format("Borrow client from pool for group %s failed.", group), (Throwable)e);
            throw e;
        }
    }

    private RaftClientReply sendReconfiguration(RaftGroup newGroupConf) throws RatisRequestFailedException {
        RaftClientReply reply;
        try (RatisClient client = this.getRaftClient(newGroupConf);){
            reply = client.getRaftClient().admin().setConfiguration(new ArrayList(newGroupConf.getPeers()));
            if (!reply.isSuccess()) {
                throw new RatisRequestFailedException((Exception)reply.getException());
            }
        }
        catch (Exception e) {
            throw new RatisRequestFailedException(e);
        }
        return reply;
    }

    public RaftServer getServer() {
        return this.server;
    }

    public void allowStaleRead(ConsensusGroupId consensusGroupId) {
        this.canServeStaleRead.computeIfAbsent(consensusGroupId, id -> new AtomicBoolean(false)).set(true);
    }

    private class RatisClientPoolFactory
    implements IClientPoolFactory<RaftGroup, RatisClient> {
        private RatisClientPoolFactory() {
        }

        public KeyedObjectPool<RaftGroup, RatisClient> createClientPool(ClientManager<RaftGroup, RatisClient> manager) {
            GenericKeyedObjectPool clientPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new RatisClient.Factory(manager, RatisConsensus.this.properties, RatisConsensus.this.clientRpc, RatisConsensus.this.config.getClient()), new ClientPoolProperty.Builder().setCoreClientNumForEachNode(RatisConsensus.this.config.getClient().getCoreClientNumForEachNode()).setMaxClientNumForEachNode(RatisConsensus.this.config.getClient().getMaxClientNumForEachNode()).build().getConfig());
            ClientManagerMetrics.getInstance().registerClientManager(this.getClass().getSimpleName(), clientPool);
            return clientPool;
        }
    }
}

